<?php

namespace AppBundle\Menu\Admin;

use AppBundle\Enum\MediaType;
use AppBundle\Enum\ModuleType;
use AppBundle\Helper\ModuleHelper;
use Knp\Menu\FactoryInterface;
use Knp\Menu\ItemInterface;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\Translation\TranslatorInterface;

class ActionBuilder
{
    /**
     * @var FactoryInterface
     */
    private $factory;

    /**
     * @var TranslatorInterface
     */
    private $translator;

    /**
     * @var mixed
     */
    private $route;

    /**
     * @var mixed
     */
    private $routeParams;

    public function __construct(
        FactoryInterface $factory, 
        TranslatorInterface $translator,
        RequestStack $requestStack)
    {
        $request = $requestStack->getCurrentRequest();
        
        $this->factory = $factory;
        $this->translator = $translator;
        $this->route = $request->get('_route');
        $this->routeParams = $request->get('_route_params');
    }

    /**
     * @return ItemInterface
     */
    public function content(): ItemInterface
    {
        $menu_type = $this->routeParams['menu_type'];
        
        $menu = $this->factory->createItem('root');
        $menu->setChildrenAttribute('class', 'menuCatalogue');

        $menu
            ->addChild('separateur', [
                'label' => $this->translator->trans('action.add.menu.separator', [], 'action'),
                'route' => 'admin_menu_add_separator',
                'routeParameters' => [
                    'menu_type' => $menu_type,
                ],
            ])
            ->setLinkAttribute('class', 'btn btn-add-separator');

        $menu
            ->addChild('url', [
                'label' => $this->translator->trans('action.add.menu.url', [], 'action'),
                'route' => 'admin_menu_add_url',
                'routeParameters' => [
                    'menu_type' => $menu_type,
                ],
            ])
            ->setLinkAttribute('class', 'btn btn-add-url');

        $menu
            ->addChild('page_simple', [
                'label' => $this->translator->trans('action.add.content.pageSimple', [], 'action'),
                'route' => 'admin_content_add_page_simple',
                'routeParameters' => [
                    'menu_type' => $menu_type,
                ],
            ])
            ->setLinkAttribute('class', 'btn btn-add-pagesimple');

        $menu
            ->addChild('page_liste', [
                'label' => $this->translator->trans('action.add.content.pageListe', [], 'action'),
                'route' => 'admin_content_add_page_liste',
                'routeParameters' => [
                    'menu_type' => $menu_type,
                ],
            ])
            ->setLinkAttribute('class', 'btn btn-add-list');

        $menu
            ->addChild('page_presentation', [
                'label' => $this->translator->trans('action.add.content.pagePresentation', [], 'action'),
                'route' => 'admin_content_add_page_presentation',
                'routeParameters' => [
                    'menu_type' => $menu_type,
                ],
            ])
            ->setLinkAttribute('class', 'btn btn-add-list');

        // $menu
        //     ->addChild('page_partners', [
        //         'label' => $this->translator->trans('action.add.content.pagePartners', [], 'action'),
        //         'route' => 'admin_content_add_page_partners',
        //         'routeParameters' => [
        //             'menu_type' => $menu_type,
        //         ],
        //     ])
        //     ->setLinkAttribute('class', 'btn btn-add-list');

        // $menu
        //     ->addChild('page_testimonials', [
        //         'label' => $this->translator->trans('action.add.content.pageTestimonials', [], 'action'),
        //         'route' => 'admin_content_add_page_testimonials',
        //         'routeParameters' => [
        //             'menu_type' => $menu_type,
        //         ],
        //     ])
        //     ->setLinkAttribute('class', 'btn btn-add-list');

        // $menu
        //     ->addChild('page_contact', [
        //         'label' => $this->translator->trans('action.add.content.pageContact', [], 'action'),
        //         'route' => 'admin_content_add_page_contact',
        //         'routeParameters' => [
        //             'menu_type' => $menu_type,
        //         ],
        //     ])
        //     ->setLinkAttribute('class', 'btn btn-add-pagesimple');

        $menu
            ->addChild('parent_categorie', [
                'label' => $this->translator->trans('action.add.content.listChild', [], 'action'),
                'route' => 'admin_content_add_list_child',
                'routeParameters' => [
                    'menu_type' => $menu_type,
                ],
            ])
            ->setLinkAttribute('class', 'btn btn-add-pres');

        $menu
            ->addChild('categorie_media', [
                'label' => $this->translator->trans('action.add.content.categoryMedia', [], 'action'),
                'route' => 'admin_content_add_category_media',
                'routeParameters' => [
                    'menu_type' => $menu_type,
                ],
            ])
            ->setLinkAttribute('class', 'btn btn-add-pres');

        $menu
            ->addChild('categorie_actualite', [
                'label' => $this->translator->trans('action.add.content.categoryActu', [], 'action'),
                'route' => 'admin_content_add_category_actu',
                'routeParameters' => [
                    'menu_type' => $menu_type,
                ],
            ])
            ->setLinkAttribute('class', 'btn btn-add-pres');

        return $menu;
    }

    /**
     * @return ItemInterface
     */
    public function slider(): ItemInterface
    {
        $menu = $this->factory->createItem('root');
        $menu->setChildrenAttribute('class', 'menuCatalogue');

        $menu
            ->addChild('add', [
                'label' => 'Ajouter une slide',
                'route' => 'admin_slider_add',
            ])
            ->setLinkAttribute('class', 'btn btn-add-slide');

        return $menu;
    }

    /**
     * @return ItemInterface
     */
    public function actu(): ItemInterface
    {
        $menu = $this->factory->createItem('root');
        $menu->setChildrenAttribute('class', 'menuCatalogue');

        $menu
            ->addChild('add', [
                'label' => $this->translator->trans('action.add.actu', [], 'action'),
                'route' => 'admin_actu_add',
            ])
            ->setLinkAttribute('class', 'btn btn-add');

        return $menu;
    }

    /**
     * @return ItemInterface
     */
    public function company(): ItemInterface
    {
        $menu = $this->factory->createItem('root');
        $menu->setChildrenAttribute('class', 'menuCatalogue');

        $menu
            ->addChild('add', [
                'label' => $this->translator->trans('action.add.company', [], 'action'),
                'route' => 'company_add',
            ])
            ->setLinkAttribute('class', 'btn btn-add');

        return $menu;
    }

    /**
     * @return ItemInterface
     */
    public function media(): ItemInterface
    {
        $menu = $this->factory->createItem('root');
        $menu->setChildrenAttribute('class', 'menuCatalogue');

        $menu
            ->addChild('pdf', [
                'label' => $this->translator->trans('action.add.media.pdf', [], 'action'),
                'route' => 'admin_media_add',
                'routeParameters' => [
                    'type' => MediaType::PDF,
                ],
            ])
            ->setLinkAttribute('class', 'btn btn-pdf')
        ;

        $menu
            ->addChild('picture', [
                'label' => $this->translator->trans('action.add.media.picture', [], 'action'),
                'route' => 'admin_media_add',
                'routeParameters' => [
                    'type' => MediaType::PICTURE,
                ],
            ])
            ->setLinkAttribute('class', 'btn btn-image')
        ;

        $menu
            ->addChild('video', [
                'label' => $this->translator->trans('action.add.media.video', [], 'action'),
                'route' => 'admin_media_add',
                'routeParameters' => [
                    'type' => MediaType::VIDEO,
                ],
            ])
            ->setLinkAttribute('class', 'btn btn-video')
        ;

        return $menu;
    }

    /**
     * @return ItemInterface
     */
    public function module(): ItemInterface
    {
        $menu = $this->factory->createItem('root');
        $menu->setChildrenAttribute('class', 'menuCatalogue');

        $typeList = ModuleHelper::getTypeList();

        foreach ($typeList as $type) {
            $menu
                ->addChild($type, [
                    'label' => $this->translator->trans('action.add.module.label', ['%name%' => $this->translator->trans('word.module.'.$type, [], 'word')], 'action'),
                    'route' => 'admin_module_add',
                    'routeParameters' => [
                        'type' => $type,
                    ],
                ])
                ->setLinkAttribute('class', 'btn btn-add')
            ;
        }
        
        return $menu;
    }

    /**
     * @return ItemInterface
     */
    public function partner(): ItemInterface
    {
        $menu = $this->factory->createItem('root');
        $menu->setChildrenAttribute('class', 'menuCatalogue');

        $menu
            ->addChild('add', [
                'label' => $this->translator->trans('action.add.partner', [], 'action'),
                'route' => 'partner_add',
            ])
            ->setLinkAttribute('class', 'btn btn-add');

        return $menu;
    }

    /**
     * @return ItemInterface
     */
    public function testimonial(): ItemInterface
    {
        $menu = $this->factory->createItem('root');
        $menu->setChildrenAttribute('class', 'menuCatalogue');

        $menu
            ->addChild('add', [
                'label' => $this->translator->trans('action.add.testimonial.label', [], 'action'),
                'route' => 'admin_testimonial_add',
            ])
            ->setLinkAttribute('class', 'btn btn-add');

        return $menu;
    }
    
    
    /**
     * @return ItemInterface
     */
    public function smsModel(): ItemInterface
    {
        $menu = $this->factory->createItem('root');
        $menu->setChildrenAttribute('class', 'menuCatalogue');

        $menu
            ->addChild('add', [
                'label' => $this->translator->trans('action.add.sms.model', [], 'action'),
                'route' => 'admin_sms_model_add',
            ])
            ->setLinkAttribute('class', 'btn btn-add');

        return $menu;
    }
}
