<?php

namespace AppBundle\Helper;

use AppBundle\Entity\Menu;
use AppBundle\Enum\TypeTemplateTitle;

class MenuHelper
{
    /**
     * Get layout path.
     * 
     * @param Menu $menu
     *
     * @return string
     */
    public static function getLayoutPath(Menu $menu)
    {
        if (!empty($menu->getTypeTemplate()) && is_object($menu->getParams()) && isset($menu->getParams()->layout)) {
            $layoutPath = 'Front/Templates/'.ucfirst($menu->getTypeTemplate());
            
            $list = self::getLayoutList($menu->getTypeTemplate());
            
            if (in_array($menu->getParams()->layout, $list)) {
                return $layoutPath.'/'.$menu->getParams()->layout;
            }
        }

        return null;
    }

    /**
     * Get layout list
     * 
     * @param string $menuTypeTemplate
     *
     * @return Array
     */
    public static function getLayoutList($menuTypeTemplate)
    {        
        if (!empty($menuTypeTemplate)) {
            $srcDir = __DIR__.'/../../../app/';
            $layoutPath = $srcDir.'Resources/views/Front/Templates/'.ucfirst($menuTypeTemplate);
            
            if (is_dir($layoutPath)) {
                $list = array_values(array_diff(scandir($layoutPath), array('..', '.')));
                // Exclude file beginning by _
                foreach ($list as $i => $file) {
                    if (preg_match('/^_/', $file)) {
                        unset($list[$i]);
                    }
                }
                return array_combine($list, $list);
            }
        }

        return array('default.html.twig' => 'default.html.twig');
    }
}