<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\Slider;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SliderType extends AbstractType
{
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('title', TextType::class, array(
                'label' => 'form.title.label',
            ))
            ->add('description', TextareaType::class, array(
                'attr' => array('class' => 'tinymce'),
                'label' => 'form.description.label',
                'required' => false,
            ))
            ->add('file', FileType::class, array(
                'attr' => array(
                    'class' => 'image_input',
                ),
                'help' => 'Dimensions idéales: 978x240',
                'image_path' => 'webPicture',
                'label' => 'form.picture.label',
                'required' => false,
            ))
            ->add('link', TextType::class, array(
                'label' => 'Lien',
                'required' => false,
            ))
            ->add('position', NumberType::class, array(
                'label' => 'form.position.label',
                'required' => false,
            ))
            ->add('is_active', CheckboxType::class, array(
                'label' => 'form.is_active.label',
                'required' => false,
            ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Slider::class,
            'translation_domain' => 'form',
        ));
    }
}
