<?php

namespace AppBundle\Form\Type\Module;

use AppBundle\Entity\Menu;
use AppBundle\Entity\Module;
use AppBundle\Enum\MenuClass;
use AppBundle\Enum\ModuleType;
use AppBundle\Enum\HtmlTag;
use AppBundle\Helper\ModuleHelper;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class NewsListType extends AbstractType
{
    private $utils;
    private $em;
    private $html_tags = array();

    /**
     * Constructor
     * 
     * @param ConstTranslator $utils 
     * @param EntityManagerInterface $em 
     */
    public function __construct(ConstTranslator $utils, EntityManagerInterface $em)
    {
        $this->utils = $utils;
        $this->em = $em;
        $this->html_tags = $utils->trans(HtmlTag::class);
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $categories_list = $this->em->getRepository(Menu::class)->findSimpleListBy([
            'typeTemplate' => 7, 
        ], [
            'position' => 'ASC'
        ]);
        
        $builder
            ->add('title', TextType::class, array(
                'label' => 'form.module.news_list.title.label',
                'required' => false,
            ))
            ->add('title_tag', ChoiceType::class, array(
                'choices' => array_flip($this->html_tags),
                'choice_translation_domain' => 'form',
                'expanded' => true,
                'label' => 'form.module.news_list.title_tag.label',
                'placeholder' => 'form.none.label',
                'required' => false,
                'attr' => array (
                    'class' => 'form-row-childs-inline'
                )
            ))
            ->add('category', ChoiceType::class, array(
                'choices' => array_flip($categories_list),
                'choice_translation_domain' => 'form',
                'expanded' => false,
                'multiple' => false,
                'label' => 'form.module.news_list.category.label',
                'required' => false,
            ))
            ->add('nb_items', NumberType::class, array(
                'label' => 'form.module.news_list.nb_items.label',
                'required' => true,
            ))
            ->add('btn_text', TextType::class, array(
                'label' => 'form.module.news_list.btn_text.label',
                'required' => false,
            ))
            ->add('btn_link', TextType::class, array(
                'label' => 'form.module.news_list.btn_link.label',
                'required' => false,
            ))
        ;     
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'translation_domain' => 'form',
        ));
    }
}
