<?php

namespace AppBundle\Form\Type;

use AppBundle\Form\Type\MailType;
use AppBundle\Mail\Model\MailPreview;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MailPreviewType extends AbstractType
{
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('mails', CollectionType::class, [
                'entry_type' => MailType::class,
                'entry_options' => [
                    'label' => false,
                ],
            ])
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => MailPreview::class,
        ]);
    }
}
