<?php

namespace AppBundle\Form\Type\Front\PEE;

use AppBundle\Entity\User;
use AppBundle\Helper\UserHelper;
use AppBundle\Repository\UserRepository;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\Query;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Validator\Constraints\UserPassword;
use Symfony\Component\Validator\Constraints\NotBlank;

class ProfDemandePEEStep3Type extends AbstractType
{
    protected $shoeSizeOptions;

    /**
     * Constructor
     * 
     * @param UserRepository $ur
     * @param ConstTranslator $utils
     */
    public function __construct(UserRepository $ur, ConstTranslator $utils)
    {
        $this->shoeSizeOptions = UserHelper::getShoeSizeOptions();
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {        
        $user_id = $options['data']->getId();

        $builder 
            ->add('shoeSize', ChoiceType::class, array(
                'choices' => $this->shoeSizeOptions,
                'label' => 'form.profile.shoeSize.label',
                // 'required' => false,
            ))
            // ->add('sendCard', ChoiceType::class, array(
            //     'choices' =>  array(
            //         "Envoi électronique" => 'digitale',
            //         "Envoi postal" => 'postale',
            //     ),
            //     'expanded' => true,
            //     'label' => 'form.profile.teacher.cni.label',
            //     'help' => 'form.profile.teacher.cni.help',
            //     // 'required' => false,
            // ))
            ->add('file', FileType::class, array(
                'attr' => array(
                    'class' => 'file_input',
                    'data-user-id' => $user_id,
                    'data-card-number' => 1
                ),
                'secure_file_name' => 'IdentityCard1',
                'secure_file_owner' => $user_id,
                'label' => $options['label_cni_recto'],
                'help' => 'form.profile.teacher.cni.recto.help',
                'required' => $options['cni_mandatory'] && $options['cni_recto']
            ))
            ->add('fileDocument', FileType::class, array(
                'attr' => array(
                    'class' => 'file_input',
                    'data-user-id' => $user_id,
                    'data-card-number' => 2
                ),
                'secure_file_name' => 'IdentityCard2',
                'secure_file_owner' => $user_id,
                'label' => $options['label_cni_verso'],
                'required' => $options['cni_mandatory'] && $options['cni_verso']
            ))
            ->add('identityCardValidity', DateType::class, array(
                'attr' => array('class' => 'with-border date'),
                'format' => 'dd/MM/yyyy',
                'label' => $options['label_validity_cni'],
                'help' => 'form.profile.teacher.cni.dateValidity.help',
                'widget' => 'single_text',
                'html5' => false,
                'required'   => $options['cni_mandatory']
            ))
            ->add('expectations', TextareaType::class, array(
                'attr' => array(
                    'rows' => 8,
                ),
                'label' => 'form.profile.teacher.expectations.label',
                // 'required' => false,
            ))
            ->add('photograph', ChoiceType::class, array(
                'choices' => array(
                    "form.profile.teacher.photograph.yes" => 1,
                    "form.profile.teacher.photograph.no" => 0
                ),
                'choice_value' => function ($currentChoiceKey) { // L'utilisation de cette fonction anonyme est rendue nécessaire par un bug de Symfony : https://github.com/symfony/symfony/issues/14712#issuecomment-112360074
                    return $currentChoiceKey ? 'true' : 'false';
                },
                'expanded' => true,
                'label' => 'form.profile.teacher.photograph.label',
                'help' => 'form.profile.teacher.photograph.help',
            ))
            // ->add('submit', SubmitType::class, array(
            //     'label' => 'form.pee.submit',
            //     'attr' => array(
            //         'class' => 'btn btn-sm btn-theme'
            //     ),
            // ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => User::class,
            'translation_domain' => 'form',
            'choice_translation_domain' => 'form',
            'label_cni_recto' => 'form.profile.teacher.cni.recto.label',
            'label_cni_verso' => 'form.profile.teacher.cni.verso.label',
            'label_validity_cni' => 'form.profile.teacher.cni.dateValidity.label',
            'cni_mandatory' => false,
            'cni_recto' => false,
            'cni_verso' => false,
            'validation_groups' => array(
                'add_pee_step3',
                'add_pee_teacher_step3',
            ),
        ));
    }
}
