<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="Preference")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\PreferenceRepository")
 * @ORM\HasLifecycleCallbacks
 */
class Preference
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var User $mainUser
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\User", inversedBy="preferencemain")
     * @ORM\JoinColumn(name="mainUser", referencedColumnName="id", nullable=false)
     */
    private $mainUser;

    /**
     * @var User $selectedUser
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\User", inversedBy="preferenceselected")
     * @ORM\JoinColumn(name="selectedUser", referencedColumnName="id", nullable=false)
     */
    private $selectedUser;


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set mainUser
     *
     * @param User $mainUser
     * @return Preference
     */
    public function setMainUser(User $mainUser)
    {
        $this->mainUser = $mainUser;

        return $this;
    }

    /**
     * Get mainUser
     *
     * @return User
     */
    public function getMainUser()
    {
        return $this->mainUser;
    }

    /**
     * Set selectedUser
     *
     * @param User $selectedUser
     * @return Preference
     */
    public function setSelectedUser(User $selectedUser)
    {
        $this->selectedUser = $selectedUser;

        return $this;
    }

    /**
     * Get selectedUser
     *
     * @return User
     */
    public function getSelectedUser()
    {
        return $this->selectedUser;
    }
}
