<?php

namespace AppBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Partner
 * @author Bastien Gatellier <contact@bgatellier.fr>
 *
 * @ORM\Entity(repositoryClass="AppBundle\Repository\PartnerRepository")
 */
class Partner extends Establishment
{
    /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="OperationPEE", mappedBy="partner", fetch="EXTRA_LAZY")
     */
    private $peeOperations;

    /**
     * @var string
     *
     * @ORM\Column(name="partner_category", type="string", length=255, nullable=true)
     */
    protected $partnerCategory;

    /**
     * @var boolean $displayInFront
     *
     * @ORM\Column(name="display_in_front", type="boolean", options={"default": false})
     */
    protected $displayInFront = false;

    /**
     * @var boolean $selectableInPEE
     *
     * @ORM\Column(name="selectable_in_pee", type="boolean", options={"default": true})
     */
    protected $selectableInPEE = true;

    /**
     * @var boolean $supportThem
     *
     * @ORM\Column(name="support_them", type="boolean", options={"default": true})
     */
    protected $supportThem = true;

    /**
     * @var boolean $supportUs
     *
     * @ORM\Column(name="support_us", type="boolean", options={"default": false})
     */
    protected $supportUs = false;


    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Add OperationPEE
     *
     * @param OperationPEE $peeOperation
     * 
     * @return Partner
     */
    public function addPeeOperation(OperationPEE $peeOperation)
    {
        $this->peeOperations[] = $peeOperation;

        return $this;
    }

    /**
     * Remove peeOperation
     *
     * @param OperationPEE $peeOperation
     */
    public function removePeeOperation(OperationPEE $peeOperation)
    {
        $this->peeOperations->removeElement($peeOperation);
    }

    /**
     * Get peeOperations
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPeeOperations()
    {
        return $this->peeOperations;
    }

    /**
     * Set category
     *
     * @param string $category
     *
     * @return Partner
     */
    public function setPartnerCategory($category)
    {
        $this->partnerCategory = $category;

        return $this;
    }

    /**
     * Get category
     *
     * @return string
     */
    public function getPartnerCategory()
    {
        return $this->partnerCategory;
    }

    /**
     * Set category
     *
     * @param string $category
     *
     * @return Partner
     */
    public function setCategory($category)
    {
        return $this->setPartnerCategory($category);
    }

    /**
     * Get category
     *
     * @return string
     */
    public function getCategory()
    {
        return $this->getPartnerCategory();
    }

    /**
     * Set if partner is displaying in front page
     *
     * @param bool $displayInFront
     *
     * @return Partner
     */
    public function setDisplayInFront($displayInFront)
    {
        $this->displayInFront = $displayInFront;

        return $this;
    }

    /**
     * Get if partner is displaying in front page
     *
     * @return bool
     */
    public function getDisplayInFront()
    {
        return $this->displayInFront;
    }

    /**
     * Set if partner is displaying in PEE Partner select field
     *
     * @param bool $selectableInPEE
     *
     * @return Partner
     */
    public function setSelectableInPEE($selectableInPEE)
    {
        $this->selectableInPEE = $selectableInPEE;

        return $this;
    }

    /**
     * Get if partner is displaying in PEE Partner select field
     *
     * @return bool
     */
    public function getSelectableInPEE()
    {
        return $this->selectableInPEE;
    }

    /**
     * Set if we support this partner
     *
     * @param bool $supportThem
     *
     * @return Partner
     */
    public function setSupportThem($supportThem)
    {
        $this->supportThem = $supportThem;

        return $this;
    }

    /**
     * Get if we support this partner
     *
     * @return bool
     */
    public function getSupportThem()
    {
        return $this->supportThem;
    }

    /**
     * Set if this partner support us
     *
     * @param bool $supportUs
     *
     * @return Partner
     */
    public function setSupportUs($supportUs)
    {
        $this->supportUs = $supportUs;

        return $this;
    }

    /**
     * Get if this partner support us
     *
     * @return bool
     */
    public function getSupportUs()
    {
        return $this->supportUs;
    }

    /**
     * Indicates if a partner can be deleted.
     * @return boolean 
     */
    public function isDeletable()
    {
        return 0 === count($this->getPeeOperations());
    }
}
