<?php

namespace AppBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="Menu")
 * @ORM\Entity
 * 
 * @ORM\Entity(repositoryClass="AppBundle\Repository\MenuRepository")
 */
class Menu
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string $title
     *
     * @ORM\Column(name="title", type="string", length=255)
     */
    private $title = "";

    /**
     * @var string $sentence
     *
     * @ORM\Column(name="sentence", type="string", length=255, nullable=true)
     */
    private $sentence;

    /**
     * @var string $slug
     *
     * @ORM\Column(name="slug", type="string", length=255, nullable=true)
     */
    private $slug;

    /**
     * @var string $class
     *
     * @ORM\Column(name="class", type="string", length=50, nullable=true)
     */
    private $class;

    /**
     * @var integer $position
     *
     * @ORM\Column(name="menu_type", type="string", length=255, nullable=true)
     */
    private $menu_type = 'main';

    /**
     * @var integer $position
     *
     * @ORM\Column(name="position", type="integer", nullable=true)
     */
    private $position = 0;

    /**
     * @var boolean $see_child
     *
     * @ORM\Column(name="see_child", type="boolean", nullable=true)
     */
    private $see_child = true;

    /**
     * @var boolean $is_active
     *
     * @ORM\Column(name="is_active", type="boolean", nullable=true)
     */
    private $is_active = true;

    /**
     * @var boolean $editable
     *
     * @ORM\Column(name="editable", type="boolean", nullable=true)
     */
    private $editable = true;

    /**
     * @var boolean $is_main_actu
     *
     * @ORM\Column(name="is_main_actu", type="boolean", nullable=true)
     */
    private $is_main_actu;

    /**
     * @var boolean $is_visible
     *
     * @ORM\Column(name="is_visible", type="boolean", nullable=true)
     */
    private $is_visible = true;

    /**
     * @var boolean $is_media
     */
    private $is_media = true;

    /**
     * @ORM\OneToMany(targetEntity="Menu", mappedBy="parent", cascade={"remove", "persist"})
     * @ORM\OrderBy({"position" = "ASC", "id" = "ASC"})
     */
    private $children;

    /**
     * @ORM\ManyToOne(targetEntity="Menu", inversedBy="children")
     * @ORM\JoinColumn(name="parent", referencedColumnName="id", nullable=true)
     */
    private $parent;

    /**
     * @ORM\ManyToOne(targetEntity="TypeTemplate", inversedBy="menu", fetch="EAGER")
     * @ORM\JoinColumn(name="typeTemplate", referencedColumnName="id", nullable=true)
     */
    private $typeTemplate;

    /**
     * @ORM\ManyToMany(targetEntity="Media", mappedBy="menu")
     * @ORM\OrderBy({"position" = "ASC", "id" = "ASC"})
     */
    private $media;


    /**
     * @ORM\OneToMany(targetEntity="Content", mappedBy="menu", cascade={"remove", "persist"})
     * @ORM\OrderBy({"is_main" = "DESC", "position" = "ASC", "id" = "ASC"})
     */
    private $content;

    /**
     * @ORM\OneToMany(targetEntity="MenuMedia", mappedBy="menu", cascade={"remove"})
     */
    protected $menumedias;

    /**
     * @var \stdClass
     *
     * @ORM\Column(name="params", type="object", nullable=true)
     */
    private $params;
    

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->children = new ArrayCollection();
        $this->content = new ArrayCollection();
        $this->media = new ArrayCollection();
        $this->menumedias = new ArrayCollection();
    }

    public function __tostring()
    {
        return $this->title;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set sentence
     *
     * @param string $sentence
     * @return Menu
     */
    public function setSentence($sentence)
    {
        $this->sentence = $sentence;

        return $this;
    }

    /**
     * Get sentence
     *
     * @return string
     */
    public function getSentence()
    {
        return $this->sentence;
    }

    /**
     * Set slug
     *
     * @param string $slug
     * @return Menu
     */
    public function setSlug($slug)
    {
        $this->slug = $slug;

        return $this;
    }

    /**
     * Get slug
     *
     * @return string
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * Set Menu Type (main or sitemap or hidden)
     *
     * @param string $menu_type
     * @return Menu
     */
    public function setMenuType($menu_type)
    {
        $this->menu_type = $menu_type;

        return $this;
    }

    /**
     * Get Menu Type (main or sitemap or hidden)
     *
     * @return string
     */
    public function getMenuType()
    {
        return $this->menu_type;
    }

    /**
     * Set position
     *
     * @param int $position
     * @return Menu
     */
    public function setPosition($position)
    {
        $this->position = $position;

        return $this;
    }

    /**
     * Get position
     *
     * @return integer
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     * Set is_active
     *
     * @param bool $isActive
     * @return Menu
     */
    public function setIsActive($isActive)
    {
        $this->is_active = $isActive;

        return $this;
    }

    /**
     * Get is_active
     *
     * @return boolean
     */
    public function getIsActive()
    {
        return $this->is_active;
    }

    /**
     * Set editable
     *
     * @param bool $editable
     * @return Menu
     */
    public function setEditable($editable)
    {
        $this->editable = $editable;

        return $this;
    }

    /**
     * Get editable
     *
     * @return boolean
     */
    public function getEditable()
    {
        return $this->editable;
    }

    /**
     * Add children
     *
     * @param Menu $children
     * @return Menu
     */
    public function addChildren(Menu $children)
    {
        $this->children[] = $children;

        return $this;
    }

    /**
     * Remove children
     *
     * @param Menu $children
     */
    public function removeChildren(Menu $children)
    {
        $this->children->removeElement($children);
    }

    /**
     * Get children
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getChildren()
    {
        return $this->children;
    }

    /**
     * Set parent
     *
     * @param Menu $parent
     * @return Menu
     */
    public function setParent(Menu $parent = null)
    {
        $this->parent = $parent;

        return $this;
    }

    /**
     * Get parent
     *
     * @return Menu
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Set typeTemplate
     *
     * @param TypeTemplate $typeTemplate
     * @return Menu
     */
    public function setTypeTemplate(TypeTemplate $typeTemplate = null)
    {
        $this->typeTemplate = $typeTemplate;

        return $this;
    }

    /**
     * Get typeTemplate
     *
     * @return TypeTemplate
     */
    public function getTypeTemplate()
    {
        return $this->typeTemplate;
    }

    /**
     * Set class
     *
     * @param string $class
     * @return Menu
     */
    public function setClass($class)
    {
        $this->class = $class;

        return $this;
    }

    /**
     * Get class
     *
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }

    /**
     * Set see_child
     *
     * @param bool $seeChild
     * @return Menu
     */
    public function setSeeChild($seeChild)
    {
        $this->see_child = $seeChild;

        return $this;
    }

    /**
     * Get see_child
     *
     * @return boolean
     */
    public function getSeeChild()
    {
        return $this->see_child;
    }

    /**
     * Add media
     *
     * @param Media $media
     * @return Menu
     */
    public function addMedia(Media $media)
    {
        $this->media[] = $media;

        return $this;
    }

    /**
     * Remove media
     *
     * @param Media $media
     */
    public function removeMedia(Media $media)
    {
        $this->media->removeElement($media);
    }

    /**
     * Get media
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMedia()
    {
        return $this->media;
    }

    /**
     * Add content
     *
     * @param Content $content
     * @return Menu
     */
    public function addContent(Content $content)
    {
        $this->content[] = $content;

        return $this;
    }

    /**
     * Remove content
     *
     * @param Content $content
     */
    public function removeContent(Content $content)
    {
        $this->content->removeElement($content);
    }

    /**
     * Get content
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return Menu
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set is_visible
     *
     * @param bool $isVisible
     * @return Menu
     */
    public function setIsVisible($isVisible)
    {
        $this->is_visible = $isVisible;

        return $this;
    }

    /**
     * Get is_visible
     *
     * @return boolean
     */
    public function getIsVisible()
    {
        return $this->is_visible;
    }

    /**
     * Set is_media
     *
     * @param bool $isMedia
     * @return Menu
     */
    public function setIsMedia($isMedia)
    {
        $this->is_media = $isMedia;

        return $this;
    }

    /**
     * Get is_media
     *
     * @return boolean
     */
    public function getIsMedia()
    {
        return $this->is_media;
    }

    /**
     * Set is_main_actu
     *
     * @param bool $isMainActu
     * @return Menu
     */
    public function setIsMainActu($isMainActu)
    {
        $this->is_main_actu = $isMainActu;

        return $this;
    }

    /**
     * Get is_main_actu
     *
     * @return boolean
     */
    public function getIsMainActu()
    {
        return $this->is_main_actu;
    }

    /**
     * Add MenuMedia
     * @param MenuMedia $menumedia
     * @return Menu
     */
    public function addMenuMedia(MenuMedia $menumedia)
    {
        $this->menumedias[] = $menumedia;

        return $this;
    }

    /**
     * Remove MenuMedia
     * @param MenuMedia $menumedia
     */
    public function removeMenuMedia(MenuMedia $menumedia)
    {
        $this->menumedias->removeElement($menumedia);
    }

    /**
     * Get menumedias
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMenuMedias()
    {
        return $this->menumedias;
    }


    /**
     * Get menumedias
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getParents()
    {
        $parents = new ArrayCollection();
        $parent = $this->parent;

        while ($parent !== null && $parent instanceof Menu) {
            $parents[] = $parent;
            $parent = $parent->getParent();
        }

        return $parents;
    }

    /**
     * Set params.
     *
     * @param \stdClass $params
     *
     * @return Menu
     */
    public function setParams($params)
    {
        $this->params = $params;

        return $this;
    }

    /**
     * Get params.
     *
     * @return \stdClass
     */
    public function getParams()
    {
        return $this->params;
    }
}
