<?php

namespace AppBundle\Controller\Module;

use AppBundle\Controller\ModuleController;
use AppBundle\Entity\Media;
use AppBundle\Entity\Menu;
use AppBundle\Entity\Module;
use AppBundle\Enum\UserType;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;

class SliderVideoController extends ModuleController
{
    /**
     * @param Int $moduleId Défini le module à afficher
     * @param string $force_layout Définit le type de rendu Twig souhaité
     * @param Int $menuId Défini le menu associé, la page actuelle qui demande l'affichage
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function renderModule(Int $moduleId, string $force_layout = null, Int $menuId = null)
    {
        $module = $this->em->getRepository(Module::class)->findOneBy([
            'isActive' => true, 
            'id' => $moduleId
        ]);
        
        if (empty($module)) {
            return new Response('');
        }

        //Force layout
        if (!empty($force_layout)) {
            $module->setLayout($force_layout);
        }
        
        $module->setFormClass($module->getType());
        $layout = $module->getLayoutPath();

        //Check if layout is correct
        if (!empty($force_layout) && strpos($layout, $force_layout) === false) {
            return new Response('');
        }

        $videos = array();
        for ($i = 1; $i <= 5; $i++) {
            $key = 'slide_'.$i.'_video_id';
            $id = (array) $module->getParams()->{$key};

            if (!empty($id)) {
                $video = $this->em->getRepository(Media::class)->findOneBy([
                    'id' => $id,
                    'type' => 'video'
                ]);

                if ($video instanceOf Media) {
                    $videos[] = $video;
                }
            }
        }

        // $listIds = (array) $module->getParams()->items;
        // $videos = $this->em->getRepository(Media::class)->findBy([
        //     'id' => $listIds,
        //     'type' => 'video'
        // ], 
        // ['title' => 'ASC', 'id' => 'ASC']);

        // $menu = $this->em->getRepository(Menu::class)->findOneBy(
        //     ['slug' => 'cgenial-tv', 'is_active' => true]
        // );

        if (empty($videos)) {
            return new Response('');
        }

        return $this->render($layout , array(
            'module' => $module, 
            'videos' => $videos,
            // 'menu' => $menu,
        ));
    }    
}
