<?php

namespace AppBundle\Controller;

use FOS\UserBundle\Controller\ChangePasswordController as BaseController;
use FOS\UserBundle\Event\FilterUserResponseEvent;
use FOS\UserBundle\Event\FormEvent;
use FOS\UserBundle\Event\GetResponseUserEvent;
use FOS\UserBundle\FOSUserEvents;
use FOS\UserBundle\Model\UserInterface;
use FOS\UserBundle\Model\UserManagerInterface;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;
use Symfony\Component\Translation\TranslatorInterface;

/**
 * 
 */
class ChangePasswordController extends BaseController
{
    /**
     * @var EventDispatcherInterface
     */
    private $dispatcher;

    /**
     * @var UserManagerInterface
     */
    private $userManager;

    /**
     * @var TranslatorInterface
     */
    private $translator;
    
    public function __construct(
        EventDispatcherInterface $dispatcher,
        UserManagerInterface $userManager,
        TranslatorInterface $translator
    )
    {
        $this->dispatcher = $dispatcher;
        $this->userManager = $userManager;
        $this->translator = $translator;
    }

    /**
     * Change user password
     * @param Request $request
     * @return null|\Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     * @throws \Twig\Error\Error
     */
    public function changePasswordAction(Request $request)
    {
        //Block this function
        $this->addFlash('error', $this->translator->trans(
            'notice.user.access_denied',
            [],
            'notice'
        ));
        return $this->redirectToRoute('espace_perso');
        
        $user = $this->getUser();
        if (!is_object($user) || !$user instanceof UserInterface) {
            //throw new AccessDeniedException('This user does not have access to this section.');

            $this->addFlash('error', $this->translator->trans(
                'notice.user.access_denied',
                [],
                'notice'
            ));
            return $this->redirectToRoute('espace_perso');
        }

        /** @var $dispatcher EventDispatcherInterface */
        $dispatcher = $this->get('event_dispatcher');

        $event = new GetResponseUserEvent($user, $request);
        $dispatcher->dispatch(FOSUserEvents::CHANGE_PASSWORD_INITIALIZE, $event);

        if (null !== $event->getResponse()) {
            return $event->getResponse();
        }

        /** @var $formFactory \FOS\UserBundle\Form\Factory\FactoryInterface */
        $formFactory = $this->get('fos_user.change_password.form.factory');

        $form = $formFactory->createForm();
        $form->setData($user);

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $event = new FormEvent($form, $request);
            $this->dispatcher->dispatch(FOSUserEvents::CHANGE_PASSWORD_SUCCESS, $event);

            $this->userManager->updateUser($user);

            if (null === $response = $event->getResponse()) {
                $response = $this->redirectToRoute('espace_perso');
            }

            $this->dispatcher->dispatch(
                FOSUserEvents::CHANGE_PASSWORD_COMPLETED,
                new FilterUserResponseEvent($user, $request, $response)
            );

            return $response;
        }

        return $this->container->get('templating')->renderResponse(
            'FOSUserBundle:ChangePassword:changePassword.html.twig',
            array('form' => $form->createView())
        );
    }
}
