<?php

namespace AppBundle\Command;

use AppBundle\Entity\User;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class SolicitationsCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('cgenial:solicitations')
            ->setDescription('Send emails to engineers without solicitation, x days after their registration.')
            ->addArgument('days', InputArgument::OPTIONAL, 'Argument description')
          //  ->addOption('option', null, InputOption::VALUE_NONE, 'Option description')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $days = $input->getArgument('days');

        if (empty($days)) {
            $days = 30;
        }

        $em = $this->getContainer()->get("doctrine.orm.entity_manager");
        $users = $em->getRepository(User::class)->findAllWithoutSolicitation($days);
        $output->writeln("--------------------------------------------------------");
        if (!empty($users)) {
            $userMailer = $this->getContainer()->get("AppBundle\\Mail\\UserMailer");

            foreach($users as $user) {

                $reponse = $userMailer->sendEmailEngineerWithoutSolicitations($user);
                if (!empty($reponse[0]) && $reponse[0]['code'] == "success") {
                    $output->writeln("[" . date('d/m/Y H:i:s') . "] " . 'Email sent successfuly to ' . $user->getEmail());
                } else {
                    $output->writeln("[" . date('d/m/Y H:i:s') . "] " . 'Email sent unsuccessfuly to ' . $user->getEmail());
                }
            }
        } else {

            $output->writeln('0 user found');
        }
        $output->writeln("--------------------------------------------------------");
    }

}
