<?php

namespace AppBundle\Command;

use AppBundle\Entity\MenuMedia;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Réinitialise l'ordre des médias au sein des pages auxquelles ils sont rattachés.
 * La position est déterminées d'après leur Id.
 */
class GenerateMenuMediaPositionsCommand extends ContainerAwareCommand
{
    /**
     * 
     */
    protected function configure()
    {
        $this
            ->setName('cgenial:generate:menumediapositions')
            ->setDescription("Réinitialisation de l'ordre des médias au sein de chaque page");
    }

    /**
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     * @throws \Doctrine\ORM\ORMException
     * @throws \Doctrine\ORM\OptimisticLockException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $em = $this->getContainer()->get("doctrine.orm.entity_manager");

        // Effacement de TOUTES les entités MenuMedia existantes
        $qbMenuMedias = $em->createQueryBuilder();
        $qbMenuMedias
            ->select('mm')
            ->from('AppBundle:MenuMedia', 'mm');
        $menuMedias = $qbMenuMedias->getQuery()->getResult();

        foreach ($menuMedias as $menuMedia) {
            $em->remove($menuMedia);
        }

        $em->flush();

        // Sélection de tous les menus auxquels sont liés des médias, et création des nouvelles entités
        $qbMenus = $em->createQueryBuilder();
        $qbMenus
            ->select('menu, media')
            ->from('AppBundle:Menu', 'menu')
            ->leftJoin('menu.media', 'media')
            ->orderBy('menu.id', 'asc')
            ->addOrderBy('media.type', 'asc')
            ->addOrderBy('media.id', 'asc');
        $menus = $qbMenus->getQuery()->getResult();

        foreach ($menus as $menu) {
            $position = 0;
            $mediaTypePrevious = null;

            foreach ($menu->getMedia() as $media) {
                if ($media->getType() !== $mediaTypePrevious) {
                    $position = 0;
                    $mediaTypePrevious = $media->getType();
                } else {
                    $position = $position + 1;
                }

                $output->writeln('Menu '.$menu->getId().', Media '.$media->getId().' ('.$media->getType().'), position: '.$position.'. '.$media->getTitle());

                $menuMedia = new MenuMedia();
                $menuMedia->setMenu($menu);
                $menuMedia->setMedia($media);
                $menuMedia->setPosition($position);

                $em->persist($menuMedia);
            }
        }

        $em->flush();
    }
}
