<?php declare(strict_types=1);

namespace Application\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\DBAL\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20180921210723 extends AbstractMigration
{
    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');


        $this->addSql('CREATE SEQUENCE sms_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE sms_campaign_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE TABLE sms (id INT NOT NULL, campaign_id INT DEFAULT NULL, user_id INT DEFAULT NULL, mobile VARCHAR(13) NOT NULL, content TEXT NOT NULL, created TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, sended_date TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, sended INT NOT NULL, sendinblue_ref VARCHAR(255) DEFAULT NULL, sendbinblue_api_return TEXT DEFAULT NULL, sendinblue_nb_sms INT DEFAULT NULL, sendinblue_credit_used DOUBLE PRECISION DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_B0A93A77F639F774 ON sms (campaign_id)');
        $this->addSql('CREATE INDEX IDX_B0A93A77A76ED395 ON sms (user_id)');
        $this->addSql('CREATE TABLE sms_campaign (id INT NOT NULL, operationpee INT DEFAULT NULL, content TEXT NOT NULL, created TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, updated TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, sended INT NOT NULL, sended_date_start TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, sended_date_end TIMESTAMP(0) WITHOUT TIME ZONE DEFAULT NULL, type VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_79E333DCAC0F4BC4 ON sms_campaign (operationpee)');
        $this->addSql('ALTER TABLE sms ADD CONSTRAINT FK_B0A93A77F639F774 FOREIGN KEY (campaign_id) REFERENCES sms_campaign (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE sms ADD CONSTRAINT FK_B0A93A77A76ED395 FOREIGN KEY (user_id) REFERENCES fos_user (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE sms_campaign ADD CONSTRAINT FK_79E333DCAC0F4BC4 FOREIGN KEY (operationpee) REFERENCES OperationPEE (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        
        $this->addSql('ALTER TABLE sms_campaign DROP CONSTRAINT FK_79E333DCAC0F4BC4');
        $this->addSql('ALTER TABLE sms DROP CONSTRAINT FK_B0A93A77F639F774');
        $this->addSql('ALTER TABLE sms DROP CONSTRAINT FK_B0A93A77A76ED395');
        $this->addSql('DROP SEQUENCE sms_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE sms_campaign_id_seq CASCADE');
        $this->addSql('DROP TABLE sms');
        $this->addSql('DROP TABLE sms_campaign');
    }
}
