<?php

namespace AppBundle\Form\Type\PEE;

use AppBundle\Entity\Company;
use AppBundle\Entity\OperationPEE;
use AppBundle\Entity\OperationPEECategory;
use AppBundle\Entity\Partner;
use AppBundle\Enum\EstablishmentAcademy;
use AppBundle\Enum\OperationPEEState;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TimeType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatorInterface;
use Vich\UploaderBundle\Form\Type\VichImageType;

class OperationPEEType extends AbstractType
{
    private $states;
    private $translator;

    /**
     * Constructor
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(TranslatorInterface $translator, ConstTranslator $utils)
    {
        $this->states = $utils->trans(OperationPEEState::class);
        $this->translator = $translator;
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $academiesConsts = EstablishmentAcademy::getConstants();
        $academies = array_combine($academiesConsts, $academiesConsts);

        $builder
            ->add('dateVisite', DateType::class, [
                'attr' => ['class' => 'date'],
                'format' => 'dd/MM/yyyy',
                'label' => 'form.date.visit.label',
                'required' => false,
                'widget' => 'single_text',
            ])
            ->add('urlExternalRegistration', TextType::class, [
                'attr' => ['placeholder' => "Exemple: http://www.ac-toulouse.fr/"],
                'label' => "Adresse du formulaire d'inscription du rectorat",
                'required' => false,
            ])
            ->add('publish', DateType::class, [
                'attr' => ['class' => 'date'],
                'format' => 'dd/MM/yyyy',
                'label' => 'Date début inscription',
                'required' => false,
                'widget' => 'single_text',
            ])
            ->add('unpublish', DateType::class, [
                'attr' => ['class' => 'date'],
                'format' => 'dd/MM/yyyy',
                'label' => 'Date fin inscription',
                'required' => false,
                'widget' => 'single_text',
            ])
            ->add('startTime', TimeType::class, [
                'label' => 'Heure de début',
                'required' => false,
                'widget' => 'text',
            ])
            ->add('endTime', TimeType::class, [
                'label' => 'Heure de fin',
                'required' => false,
                'widget' => 'text',
            ])
            ->add('company', EntityType::class, [
                'class' => Company::class,
                'label' => $this->translator->transchoice('form.company.label', 1, [], 'form'),
                'query_builder' => function(EntityRepository $er) {
                    return $er
                        ->createQueryBuilder('c')
                        ->orderBy('c.name')
                    ;
                },
            ])
            ->add('partner', EntityType::class, [
                'class' => Partner::class,
                'label' => $this->translator->transchoice('form.partner.label', 1, [], 'form'),
                'query_builder' => function(EntityRepository $er) {
                    return $er
                        ->createQueryBuilder('p')
                        ->orderBy('p.name')
                    ;
                },
                'required' => false,
            ])
            ->add('site', TextType::class, [
                'label' => 'Site',
            ])
            ->add('siteImage1File', VichImageType::class, [
                'download_uri' => false,
                'help' => 'Formats autorisés: GIF, JPG, PNG',
                'imagine_pattern' => '128Lx128H',
                'label' => 'Photo du site',
                'required' => false,
            ])
            ->add('siteImage2File', VichImageType::class, [
                'download_uri' => false,
                'help' => 'Formats autorisés: GIF, JPG, PNG',
                'imagine_pattern' => '128Lx128H',
                'label' => 'Photo du site',
                'required' => false,
            ])
            ->add('siteImage3File', VichImageType::class, [
                'download_uri' => false,
                'help' => 'Formats autorisés: GIF, JPG, PNG',
                'imagine_pattern' => '128Lx128H',
                'label' => 'Photo du site',
                'required' => false,
            ])
            ->add('city', TextType::class, [
                'label' => 'form.city.label',
                'required' => false,
            ])
            ->add('academy', ChoiceType::class, [
                'choices' => $academies,
                'label' => 'form.academy.label',
                'required' => false,
            ])
            ->add('nbPeople', IntegerType::class, [
                'label' => 'Nb de participants acceptés',
                'required' => false,
            ])
            ->add('state', ChoiceType::class, [
                'choices' => array_flip($this->states),
                'label' => 'form.state.label',
            ])
            ->add('note', TextareaType::class, [
                'attr' => [
                    'rows' => 5,
                ],
                'label' => 'form.notes.label',
                'required' => false,
            ])
            ->add('title', TextType::class, [
                'label' => 'form.title.label',
                'required' => false,
            ])
            ->add('presentation', TextareaType::class, [
                'attr' => [
                    'rows' => 5,
                ],
                'label' => 'form.presentation.label',
                'required' => false,
            ])
            ->add('visit', TextareaType::class, [
                'attr' => [
                    'rows' => 10
                ],
                'label' => 'form.visit.label',
                'required' => false,
            ])
            ->add('namely', TextType::class, [
                'label' => 'form.namely.label',
                'required' => false,
            ])
            ->add('audience', TextType::class, [
                'label' => 'form.audience.label',
                'required' => false,
            ])
            ->add('address', TextType::class, [
                'label' => 'form.address.label',
                'required' => false,
            ])
            ->add('zipCode', TextType::class, [
                'label' => 'form.zipcode.label',
                'required' => false,
            ])
            ->add('latitude', TextType::class, [
                'label' => 'form.latitude.label',
                'required' => false,
            ])
            ->add('longitude', TextType::class, [
                'label' => 'form.longitude.label',
                'required' => false,
            ])
            ->add('quoteContent', TextareaType::class, [
                'attr' => [
                    'rows' => 5,
                ],
                'label' => 'form.quote.label',
                'required' => false,
            ])
            ->add('quoteAuthor', TextType::class, [
                'label' => 'form.author.label',
                'required' => false,
            ])
            ->add('quoteAuthorJob', TextType::class, [
                'label' => 'form.job.label',
                'required' => false,
            ])
            ->add('category', EntityType::class, [
                'class' => OperationPEECategory::class,
                'label' => 'form.category.label',
                'placeholder' => ' ',
                'query_builder' => function(EntityRepository $er) {
                    return $er
                        ->createQueryBuilder('c')
                        ->where('c.isActive = :is_active')
                        ->setParameter('is_active', true)
                        ->orderBy('c.name')
                    ;
                },
                'required' => false,
            ])
            ->add('new', CheckboxType::class, [
                'label' => 'form.new.location.label',
                'required' => false,
            ])
            ->add('is_identity_mandatory', CheckboxType::class, [
                'label' => 'form.pee.cni.label',
                'required' => false,
            ])
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => OperationPEE::class,
            'translation_domain' => 'form',
        ]);
    }
}
