<?php

namespace AppBundle\Form\Type\Menu;

use AppBundle\Entity\Menu;
use AppBundle\Enum\MenuClass;
use AppBundle\Enum\MenuPosition;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class UrlMenuType extends AbstractType
{
    /**
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(ConstTranslator $utils)
    {
        $this->classes = $utils->trans(MenuClass::class);
        $this->menu_types = $utils->trans(MenuPosition::class);
    }
    
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $menuType = $options['data']->getMenuType();
        
        $builder
            ->add('title', TextType::class, array(
                'label' => 'form.menu.title.label',
            ))
            ->add('menu_type', ChoiceType::class, array(
                'choices' => array_flip($this->menu_types),
                'choice_label' => function ($choiceValue, $key, $value) {
                    return 'menu.menu.'.$value.'.label';
                },
                'choice_translation_domain' => 'menu',
                'translation_domain' => 'form',
                //'label' => 'form.menu.menu_type.label',
                'label' => 'Menu',
                'disabled' => true,
            ))
            ->add('parent', EntityType::class, array(
                'choice_label'  => 'title',
                'class' => 'AppBundle:Menu',
                'label' => 'form.menu.parent.label',
                'placeholder' => 'form.menu.parent.placeholder',
                'query_builder' => function(EntityRepository $er) use ( $menuType ) {
                    return $er->createQueryBuilder('m')
                            ->where('m.menu_type = :menu_type')
                            ->setParameter('menu_type', $menuType)
                            ->orderBy('m.title', 'ASC');
                },
                'required'  => false,
            ))
            ->add('slug', TextType::class, array(
                'label' => 'Url',
            ))
            // ->add('sentence', TextType::class, array(
            //     'label' => 'form.menu.sentence.label' ,
            //     'required' => false,
            // ))
            // ->add('class', ChoiceType::class, array(
            //     'choices' => array_flip($this->classes),
            //     'choice_translation_domain' => 'form',
            //     'expanded' => true,
            //     'label' => 'form.theme.color.label',
            //     'placeholder' => 'form.none.label',
            //     'required' => false,
            //     'attr' => array (
            //         'class' => 'form-row-childs-inline color_class'
            //     )
            // ))
            ->add('position', NumberType::class, array(
                'label' => 'form.position.label',
                'required' => false,
            ))
            ->add('is_active', CheckboxType::class, array(
                'label' => 'form.is_active.label',
                'required' => false,
            ))
            ->add('is_visible', HiddenType::class, array(
                //'label' => 'form.menu.is_visible.label',
                'data' => 't',
                'required' => false,
            ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Menu::class,
            'translation_domain' => 'form',
        ));
    }
}
