<?php

namespace AppBundle\Form\Type\ITDLC;

use AppBundle\Entity\SettingsOperationITDLC;
use AppBundle\Form\Type\DocumentType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatorInterface;

class SettingsOperationITDLCType extends AbstractType
{
    /**
     * @var TranslatorInterface
     */
    private $translator;

    public function __construct(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('teacherDocuments', CollectionType::class, [
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
                'entry_type' => DocumentType::class,
                'entry_options' => [
                    'label' => false,
                ],
                'error_bubbling' => false,
                'label' => 'form.documents.teacher.label',
                'label_add' => $this->translator->trans('action.add.document', [], 'action'),
                'label_delete' => $this->translator->trans('action.delete.document', [], 'action'),
                'required' => false,
            ])
            ->add('engineerDocuments', CollectionType::class, [
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
                'entry_type' => DocumentType::class,
                'entry_options' => [
                    'label' => false,
                ],
                'error_bubbling' => false,
                'label' => 'form.documents.engineer.label',
                'label_add' => $this->translator->trans('action.add.document', [], 'action'),
                'label_delete' => $this->translator->trans('action.delete.document', [], 'action'),
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => SettingsOperationITDLC::class,
            'translation_domain' => 'form',
        ]);
    }
}
