<?php

namespace AppBundle\Form\Type\Front\User;

use AppBundle\Translation\ConstTranslator;
use FOS\UserBundle\Form\Type\RegistrationFormType as RegistrationFormTypeBase;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatorInterface;
use AppBundle\Enum\UserHonorific;
use AppBundle\Enum\UserType;

class RegistrationFormType extends AbstractType
{
    protected $translator;
    private $userHonorifics;
    private $userType;

    /**
     * Constructor
     * @param ConstTranslator $utils
     */
    public function __construct(TranslatorInterface $translator, ConstTranslator $utils)
    {
        $this->translator = $translator;
        
        $this->userHonorifics = $utils->trans(UserHonorific::class);
        $this->userType = $utils->trans(UserType::class);

        // Demande client - Changer "Enseignant" par "membre de l'Education nationale
        $this->userType[UserType::TEACHER] = $this->translator->trans('word.type.user.educ_nat.label', [], 'word');
    }
    
    /**
     *
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->remove('username')
            ->remove('email')
            ->remove('plainPassword')
            ->add('honorific', ChoiceType::class, [
                'choices' => array_flip($this->userHonorifics),
                //'expanded' => true,
                'label' => 'form.profile.honorific.label',
            ])
            ->add('firstname', TextType::class, [
                'label' => 'form.profile.firstname.label',
            ])
            ->add('lastname', TextType::class, [
                'label' => 'form.profile.lastname.label',
            ])
            ->add('type', ChoiceType::class, [
                'choices' => array_flip($this->userType),
                //'expanded' => true,
                'label' => 'form.profile.type.label',
            ])
            ->add('email', RepeatedType::class, [
                'type' => EmailType::class,
                'first_options' => ['label' => 'form.profile.email.label'],
                'second_options' => ['label' => 'form.profile.email.email_confirmation.label'],
                'invalid_message' => $this->translator->trans('form.profile.email.email_confirmation.mismatch', [], 'form'), //"Les adresses e-mail ne correspondent pas.",
            ])
            // ->add('plainPassword', RepeatedType::class, [
            //     'type' => PasswordType::class,
            //     'first_options' => ['label' => 'form.profile.password.label'],
            //     'second_options' => ['label' => 'form.profile.password.password_confirmation.label'],
            //     'invalid_message' => $this->translator->trans('form.profile.password.password_confirmation.mismatch', [], 'form'), //"Les mots de passe ne correspondent pas.",
            // ])
            ->add('plainPassword', PasswordType::class, [
                'label' => 'form.profile.password.label',
                'help' => 'form.profile.password.new_password.help',
            ])
            ->add('submit', SubmitType::class, [
                'label' => 'form.registration.submit',
                'attr' => array(
                    'class' => 'btn btn-block btn-md btn-theme'
                ),
            ])
        ;
    }

    /**
     *
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'translation_domain' => 'form',
            'validation_groups' => [
                'registration_step1',
            ]
        ]);
        
    }

    /**
     *
     * @return string
     */
    public function getParent(): string
    {
        return RegistrationFormTypeBase::class;
    }
}
