<?php

namespace AppBundle\Form\Type\Front\ITDLC;

use AppBundle\Entity\OperationITDLC;
use AppBundle\Entity\MerItdlc;
use AppBundle\Entity\User;
use AppBundle\Enum\ClassroomLevel;
use AppBundle\Enum\ClassroomOption;
use AppBundle\Enum\ITDLCGoalCategory;
use AppBundle\Enum\ITDLCPeriod;
use AppBundle\Form\Type\MerITDLCStep3Type;
use AppBundle\Repository\UserRepository;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\Query;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

class ProfDemandeITDLCStep3Type extends AbstractType
{
    private $classroomLevels;

    private $classroomOptions;
    
    /**
     * Constructor
     *
     * @param UserRepository $ur
     * @param ConstTranslator $utils
     */
    public function __construct(UserRepository $ur, ConstTranslator $utils)
    {
        $this->classroomLevels = $utils->trans(ClassroomLevel::class);

        $this->classroomOptions = $utils->trans(ClassroomOption::class);

        $this->goalCategoryOptions = $utils->trans(ITDLCGoalCategory::class);

        $this->periodOptions = $utils->trans(ITDLCPeriod::class);
    }

    /**
     *
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder 
            ->add('classLevel', ChoiceType::class, array(
                'choices' => array_flip($this->classroomLevels),
                'label' => 'form.itdlc.classLevel.label',
            ))
            ->add('classOption', ChoiceType::class, array(
                'choices' => array_flip($this->classroomOptions),
                'label' => 'form.itdlc.classOption.label',
                'required' => false,
            ))
            ->add('goalCategory', ChoiceType::class, array(
                'choices' => array_flip($this->goalCategoryOptions),
                'label' => 'form.itdlc.goalCategory.label',
            ))
            ->add('goal', TextareaType::class, array(
                'label' => 'form.itdlc.goal.label',
                'help' => 'form.itdlc.goal.help',
            ))
            ->add('nbStudent', IntegerType::class, array(
                'help' => 'Vous pourrez modifier cette valeur ultérieurement',
                'label' => "Nombre d'élèves prévus",
                'scale' => 0,
            ))
   
            
            ->add('merITDLC', CollectionType::class, array(
                'entry_type' => MerITDLCStep3Type::class,
                'label' => "Proposez 3 dates d'intervention",
                'allow_add' => true,
                'allow_delete' => false,
                'prototype' => true,
                'by_reference' => false,
            ))
           
            /*
            ->add('period', ChoiceType::class, array(
                'choices' => array_flip($this->periodOptions),
                'label' => 'form.itdlc.period.label',
            ))
            */
            // ->add('submit', SubmitType::class, array(
            //     'label' => 'form.itdlc.submit',
            //     'attr' => array(
            //         'class' => 'btn btn-sm btn-theme'
            //     ),
            // ))
        ;

      
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => OperationITDLC::class,
            'translation_domain' => 'form',
            'choice_translation_domain' => 'form',
            'validation_groups' => array(
                'add_itdlc_step3',
                'add_itdlc_teacher_step3',
            ),
        ));
    }
}
