<?php

namespace AppBundle\Form\Type\Front\ITDLC\Legacy;

use AppBundle\Enum\ClassroomLevel;
use AppBundle\Translation\ConstTranslator;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use AppBundle\Entity\User;

class IngeDemandeITDLCType extends AbstractType
{
    private $classrooms;

    /**
     * Constructor
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(ConstTranslator $utils)
    {
        $this->classrooms = $utils->trans(ClassroomLevel::class);
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('classroom', ChoiceType::class, [
                'label' => 'Niveaux des classes souhaités pour intervenir',
                'choices' => array_flip($this->classrooms),
                'multiple' => true,
                'expanded' => true,
            ])
            ->add('transporttime', IntegerType::class, [
                'label' => 'Temps maximal de déplacement accepté pour le trajet aller (en minutes)',
            ])
            ->add('transportkm', IntegerType::class, [
                'label' => 'Distance maximale de déplacement acceptée pour le trajet aller (en kilomètres)',
            ])
            ->add('publictransport', CheckboxType::class, [
                'label' => 'Cocher cette case si vous vous déplacez en transport en commun',
                'required' => false,
            ])
            ->add('nbcontribution', IntegerType::class, [
                'label' => 'Nombre dʼinterventions souhaitées par an',
            ])
            ->add('briefing', TextareaType::class, [
                'label' => 'Thèmes et objectifs envisagés de la future intervention',
                'required' => false,
            ])
            ->add('submit', SubmitType::class, [
                'label' => 'profile.edit.submit',
                'translation_domain' => 'FOSUserBundle',
                'attr' => array(
                    'class' => 'btn btn-sm btn-theme'
                ),
            ])
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class'  => User::class,
            'translation_domain' => 'form',
            'validation_groups' => [
                'OperationITDLCEngineer'
            ]
        ]);
    }
}
