<?php

namespace AppBundle\Form\Type\Front\ITDLC;

use AppBundle\Entity\Company;
use AppBundle\Entity\User;
use AppBundle\Enum\ClassroomLevel;
use AppBundle\Enum\UserHonorific;
use AppBundle\Enum\UserJobEngineer;
use AppBundle\Enum\UserJobEngineerCategory;
use AppBundle\Enum\UserSchoolGrade;
use AppBundle\Helper\UserHelper;
use AppBundle\Repository\CompanyRepository;
use AppBundle\Repository\UserRepository;
use AppBundle\Translation\ConstTranslator;
use FOS\UserBundle\Form\Type\ProfileFormType as BaseProfileFormType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

/**
 *
 */
class IngeDemandeITDLCStep3Type extends AbstractType
{
    protected $transportTypeOptions;
    protected $transportDistanceOptions;
    protected $transportTimeOptions;
    protected $nbContributionsOptions;
    
    /**
     * Constructor
     * 
     * @param UserRepository $ur
     * @param ConstTranslator $utils
     */
    public function __construct(UserRepository $ur, ConstTranslator $utils)
    {
        $this->transportTypeOptions = UserHelper::getTransportTypeOptions();
        $this->transportDistanceOptions = UserHelper::getTransportDistanceOptions();
        $this->transportTimeOptions = UserHelper::getTransportTimeOptions();
        $this->nbContributionsOptions = UserHelper::getNbContributionsOptions();
        $this->classroomLevels = $utils->trans(ClassroomLevel::class);
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder 
            ->add('publictransport', ChoiceType::class, [
                'choices' => array_flip($this->transportTypeOptions),
                'label' => 'form.profile.engineer.publictransport.label',
                // 'required' => false,
            ])
            ->add('transportkm', ChoiceType::class, [
                'choices' => array_flip($this->transportDistanceOptions),
                'label' => 'form.profile.engineer.transportkm.label',
                // 'required' => false,
            ])
            ->add('transporttime', ChoiceType::class, [
                'choices' => array_flip($this->transportTimeOptions),
                'label' => 'form.profile.engineer.transporttime.label',
                // 'required' => false,
            ])
            ->add('classroom', ChoiceType::class, [
                'label' => 'form.profile.engineer.classroom.label',
                'choices' => array_flip($this->classroomLevels),
                'multiple' => true,
                'expanded' => true,
                // 'required' => false,
            ])
            ->add('nbcontribution', ChoiceType::class, [
                'choices' => array_flip($this->nbContributionsOptions),
                'label' => 'form.profile.engineer.nbcontribution.label',
                // 'required' => false,
            ])
            ->add('availabilities', CollectionType::class, [
                'label' => 'form.profile.availabilities.label',
                'entry_type' => ChoiceType::class,
                'entry_options' => array(
                    'label' => false,
                    'choices' => array(
                        'word.everytime.label' => '',
                        'word.days.label' => array_flip(array(
                            'monday' => 'word.days.monday.label',
                            'tuesday' => 'word.days.tuesday.label',
                            'wednesday' => 'word.days.wednesday.label',
                            'thursday' => 'word.days.thursday.label',
                            'friday' => 'word.days.friday.label',
                            // 'saturday' => 'word.days.saturday.label',
                            // 'sunday' => 'word.days.sunday.label',
                        )),
                        'word.months.label' => array_flip(array(
                            'january' => 'word.months.january.label',
                            'february' => 'word.months.february.label',
                            'march' => 'word.months.march.label',
                            'april' => 'word.months.april.label',
                            'may' => 'word.months.may.label',
                            'june' => 'word.months.june.label',
                            // 'july' => 'word.months.july.label',
                            // 'august' => 'word.months.august.label',
                            'september' => 'word.months.september.label',
                            'october' => 'word.months.october.label',
                            'november' => 'word.months.november.label',
                            'december' => 'word.months.december.label',
                        )),
                    ),
                    'translation_domain' => 'form',
                    'choice_translation_domain' => 'word',
                ),
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
                'label_add' => 'form.collection.btn.availabilities.add',
                'label_delete' => 'form.collection.btn.availabilities.delete',
                'error_bubbling' => false,
                'required' => false,
            ])  
            // ->add('submit', SubmitType::class, array(
            //     'label' => 'form.itdlc.submit',
            //     'attr' => array(
            //         'class' => 'btn btn-sm btn-theme'
            //     ),
            // ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => User::class,
            'translation_domain' => 'form',
            'validation_groups' => [
                'add_itdlc_step3',
                'add_itdlc_engineer_step3'
            ]
        ]);
    }
}
