<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\Content;
use AppBundle\Entity\Menu;
use AppBundle\Enum\TypeTemplateTitle;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class BlocContentType extends AbstractType
{
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $articleOptionsAdditional = array();
        $fileHelp = null;
        $menu = $options['data']->getMenu();

        if ($menu instanceof Menu && TypeTemplateTitle::LIST === $menu->getTypeTemplate()->getTitle()) {
            $articleOptionsAdditional['help'] = 'Pour rendre une image cliquable: insérer l\'url dans le document puis transformez-là en lien à l\'aide du bouton "Insérer un lien". Sélectionner le lien ainsi créé et lui attribuer le format spécial "lien..." (par exemple, "lien partenaires").';

            $fileHelp = 'Dimensions idéales: 148x148';
        }

        $builder
            ->add('title', TextType::class, array(
                'label' => 'form.title.label',
            ))
            ->add('file', FileType::class, array(
                'attr' => array(
                    'class' => 'image_input',
                ),
                'help' => $fileHelp,
                'image_path' => 'webPicture',
                'label' => 'form.picture.label',
                'required' => false,
            ))
            ->add('article', TextareaType::class, array_merge(array(
                'attr' => array(
                    'class' => 'tinymce tinymce-grey-background',
                ),
                'label' => 'form.description.label',
                'required' => false,
            ), $articleOptionsAdditional))
            ->add('position', NumberType::class, array(
                'label' => 'form.position.label',
                'required' => false,
            ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Content::class,
            'translation_domain' => 'form',
        ));
    }
}
