<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\Availability;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TimeType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class AvailabilityPrecisType extends AbstractType
{
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('dateVisite', DateType::class, array(
                'attr' => array('class' => 'date with-border'),
                'format' => 'dd/MM/yyyy',
                'label' => 'form.availability.dateVisite.label',
                'widget' => 'single_text',
            ))
            ->add('startTime', TimeType::class, array(
                'label' => 'form.availability.startTime.label',
                'widget' => 'choice',
                'hours' => range(8, 18),
                'minutes' => array(0, 30),
                'attr' => array('class' => 'time with-border'),
            ))
            ->add('endTime',TimeType::class, array(
                'label' => 'form.availability.endTime.label',
                'widget' => 'choice',
                'hours' => range(8, 18),
                'minutes' => array(0, 30),
                'attr' => array('class' => 'time with-border'),
            ))
            ->add('submit', SubmitType::class, [
                'label' => 'action.add.availability.precise',
                'translation_domain' => 'action',
                'attr' => array(
                    'class' => 'btn btn-sm btn-theme'
                ),
            ])
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Availability::class,
            'translation_domain' => 'form',
        ));
    }
}
