<?php

namespace AppBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use FOS\UserBundle\Model\User as BaseUser;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Context\ExecutionContextInterface;
use AppBundle\Enum\UserRep;
use AppBundle\Enum\UserType;
use AppBundle\Helper\UserHelper;

/**
 * @ORM\Entity(repositoryClass="AppBundle\Repository\UserRepository")
 * @ORM\Table(name="fos_user")
 * @ORM\HasLifecycleCallbacks
 */
class User extends BaseUser
{
    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var int
     *
     * @ORM\Column(name="import_id_professor", type="integer", nullable=true)
     */
    protected $importIdProfessor;

    /**
     * @var int
     *
     * @ORM\Column(name="import_id_enginner", type="integer", nullable=true)
     */
    protected $importIdEnginner;

    /**
     * @var string
     *
     * @ORM\Column(name="type", type="string", length=50, nullable=true)
     */
    private $type;

    /**
     * @var string
     *
     * @ORM\Column(name="clearpassword", type="string", length=50, nullable=true)
     */
    private $clearPassword;

    /**
     * @var string
     *
     * @ORM\Column(name="firstname", type="string", length=50, nullable=true)
     */
    private $firstname;

    /**
    * @var string
    *
    * @ORM\Column(name="lastname", type="string", length=50, nullable=true)
    */
    private $lastname;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created", type="date", nullable=true)
     */
    private $created;

    /**
     * @var boolean
     *
     * @ORM\Column(name="is_active", type="boolean", nullable=true)
     */
    private $is_active = true;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="birthday", type="date", nullable=true)
     */
    private $birthday;

    /**
     * @var string
     *
     * @ORM\Column(name="phone", type="string", length=50, nullable=true)
     */
    private $phone;

    /**
     * @var string
     *
     * @ORM\Column(name="mobile", type="string", length=50, nullable=true)
     */
    private $mobile;

    /**
     * @var string
     *
     * @ORM\Column(name="classroom", type="string", length=255, nullable=true)
     */
    private $classroom;

    /**
     * @var string
     *
     * @ORM\Column(name="jobcategory", type="string", length=255, nullable=true)
     */
    private $categoryJob;

    /**
     * @var string
     *
     * @ORM\Column(name="job", type="string", length=255, nullable=true)
     */
    private $job;

    /**
     * @var string
     *
     * @ORM\Column(name="jobOther", type="string", length=255, nullable=true)
     */
    private $jobOther;

    /**
     * Only UserType::TEACHER
     * @var string
     *
     * @ORM\Column(name="bossEmail", type="string", length=255, nullable=true)
     */
    private $bossEmail;

    /**
     * Only UserType::ENGINEER
     * 
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Establishment", inversedBy="users", fetch="EXTRA_LAZY")
     */
    private $establishment;

    /**
     * Only UserType::TEACHER
     * @var string
     *
     * @ORM\Column(name="establishmentType", type="string", length=255, nullable=true)
     */
    private $establishmentType;

    /**
     * Only UserType::TEACHER
     * @var string
     *
     * @ORM\Column(name="establishmentEducation", type="string", length=255, nullable=true)
     */
    private $establishmentEducation;

    /**
     * Only UserType::ENGINEER
     * 
     * @ORM\ManyToOne(targetEntity="OperationPEECategory", inversedBy="users", fetch="EXTRA_LAZY")
     */
    private $establishmentSector;

    /**
     * Only UserType::ENGINEER
     * @var string
     *
     * @ORM\Column(name="establishmentSectorOther", type="string", length=255, nullable=true)
     */
    private $establishmentSectorOther;

    /**
     * @var string
     *
     * @ORM\Column(name="establishmentName", type="string", length=255, nullable=true)
     */
    private $establishmentName;

    /**
     * Only UserType::ENGINEER
     * @var string
     *
     * @ORM\Column(name="establishmentNameOther", type="string", length=255, nullable=true)
     */
    private $establishmentNameOther;

    /**
     * @var string
     *
     * @ORM\Column(name="establishmentEmail", type="string", length=255, nullable=true)
     */
    private $establishmentEmail;

    /**
     * @var string
     *
     * @ORM\Column(name="establishmentAddress", type="string", length=255, nullable=true)
     */
    private $establishmentAddress;

    /**
     * @var string
     *
     * @ORM\Column(name="establishmentZipcode", type="string", length=50, nullable=true)
     */
    private $establishmentZipcode;

    /**
     * @var string
     *
     * @ORM\Column(name="establishmentCity", type="string", length=255, nullable=true)
     */
    private $establishmentCity;

    /**
     * @var string
     *
     * @ORM\Column(name="personalAddress", type="string", length=255, nullable=true)
     */
    private $personalAddress;

    /**
     * @var string
     *
     * @ORM\Column(name="personalZipcode", type="string", length=50, nullable=true)
     */
    private $personalZipcode;

    /**
     * @var string
     *
     * @ORM\Column(name="personalCity", type="string", length=255, nullable=true)
     */
    private $personalCity;

    /**
     * Calculated from the personal coordinates: address and zipcode
     * @var float
     *
     * @ORM\Column(name="personalLatitude", type="float", nullable=true)
     */
    private $personalLatitude = null;

    /**
     * Calculated from the personal coordinates: address and zipcode
     * @var float
     *
     * @ORM\Column(name="personalLongitude", type="float", nullable=true)
     */
    private $personalLongitude = null;

    /**
     * Only UserType::TEACHER
     * @var string
     *
     * @ORM\Column(name="briefing", type="text", nullable=true)
     */
    private $briefing;

    /**
     * @var string
     *
     * @ORM\Column(name="note", type="text", nullable=true)
     */
    private $note;

    /**
     * @var boolean
     *
     * @ORM\Column(name="newsletter", type="boolean", nullable=true)
     */
    private $newsletter;

    /**
     * Only UserType::ENGINEER
     * @var integer
     *
     * @ORM\Column(name="nbContribution", type="integer", nullable=true)
     */
    private $nbContribution;

    /**
     * Only UserType::ENGINEER
    * @var string
    *
    * @ORM\Column(name="formation", type="string", length=255, nullable=true)
    */
    private $formation;

    /**
     * Only UserType::ENGINEER
    * @var string
    *
    * @ORM\Column(name="formationType", type="string", length=255, nullable=true)
    */
    private $formationType;

    /**
     * Only UserType::ENGINEER
     * @deprecated
    * @var string
    *
    * @ORM\Column(name="detailFormation", type="text", nullable=true)
    */
    private $detailFormation;

    /**
     * Only UserType::ENGINEER
    * @var string
    *
    * @ORM\Column(name="aboutMe", type="text", nullable=true)
    */
    private $aboutMe;

    /**
     * Only UserType::ENGINEER
     * @var boolean
     *
     * @ORM\Column(name="publicTransport", type="boolean", nullable=true)
     */
    private $publicTransport;

    /**
     * Only UserType::TEACHER
     * @deprecated
     * @var boolean
     *
     * @ORM\Column(name="professionalDiscover", type="boolean", nullable=true)
     */
    private $professionalDiscover;

    /**
     * Only UserType::ENGINEER
     * @var int
     *
     * @ORM\Column(name="transportTime", type="integer", nullable=true)
     */
    private $transportTime;

    /**
     * Only UserType::ENGINEER
     * @var int
     *
     * @ORM\Column(name="transportKm", type="integer", nullable=true)
     */
    private $transportKm;

    /**
     * @var string
     */
    private $importId;

    /**
     * Only UserType::TEACHER
     * @var string
     *
     * @ORM\Column(name="academy", type="string", length=255, nullable=true)
     */
    private $academy;

    /**
     * Only UserType::TEACHER
     * @var string
     *
     * @ORM\Column(name="rep", type="string", length=255, nullable=true)
     */
    private $rep = UserRep::LEVEL0;

    /**
     * @var boolean
     *
     * @ORM\Column(name="isValideInfo", type="boolean", nullable=true)
     */
    private $isValideInfo;

    /**
     * @var string
     *
     * @ORM\Column(name="sendCard", type="string", length=255, nullable=true)
     */
    private $sendCard;

    /**
     * @var string
     *
     * @ORM\Column(name="identityCard1", type="string", length=255, nullable=true)
     */
    private $identityCard1;

    /**
     * @var string
     *
     * @ORM\Column(name="identityCard2", type="string", length=255, nullable=true)
     */
    private $identityCard2;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="identitycardvalidity", type="date", nullable=true)
     */
    private $identityCardValidity;

    /**
     * Indique si l'utilisateur souhaite ou non que son image soit utilisée sur les photos publiées par CGénial
     * @var boolean
     *
     * @ORM\Column(name="photograph", type="boolean", nullable=true)
     */
    private $photograph;

    /**
     * Photo personnelle de l'utilisateur.
     * Seule l'extension du fichier est conservée en BDD, le nom de fichier étant l'ID de l'utilisateur
     * @var string
     * @ORM\Column(name="photo", type="string", nullable=true)
     */
    private $photo;

    /**
     * @var UploadedFile
     */
    private $photoFile;

    /**
     * @var string
     */
    private $photoTemp;

    /**
     * Only UserType::TEACHER
     * @var integer
     *
     * @ORM\Column(name="shoeSize", type="integer", nullable=true)
     */
    private $shoeSize;

    /**
     * Calculated from the establishment coordinates: address, zipcode and city
     * @var float
     *
     * @ORM\Column(name="latitude", type="float", nullable=true)
     */
    private $latitude = null;

    /**
     * Calculated from the establishment coordinates: address, zipcode and city
     * @var float
     *
     * @ORM\Column(name="longitude", type="float", nullable=true)
     */
    private $longitude = null;

    /**
     * @var integer
     *
     * @ORM\Column(name="honorific", type="integer", nullable=true)
     */
    private $honorific = null;

    /**
    * @var string
    *
    * @ORM\Column(name="expectations", type="text", nullable=true)
    */
    private $expectations;

    /**
     * @var string
     */
    private $identityCard;

    /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\DemandePEE", mappedBy="cuser", fetch="EXTRA_LAZY")
     */
    private $demandepee;

    /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\OperationITDLC", mappedBy="prof", fetch="EXTRA_LAZY")
     */
    private $profitdlc;

    /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\OperationITDLC", mappedBy="inge", fetch="EXTRA_LAZY")
     */
    private $ingeitdlc;

    /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\Preference", mappedBy="mainUser", cascade={"remove", "persist"})
     */
    private $preferencemain;

    /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\Preference", mappedBy="selectedUser", cascade={"remove", "persist"})
     */
    private $preferenceselected;

    /**
     * @var boolean
     *
     * @ORM\Column(name="is_available", type="boolean", nullable=true)
     */
    private $is_available = true;

    /**
     * @var integer
     *
     * @ORM\Column(name="number_no_answer", type="integer", nullable=true)
     */
    private $numberNoAnswer = true;

    
    /**
     * @ORM\Column(name="availabilities", type="array", nullable=true)
     */
    private $availabilities = array();

    /**
     * @var ArrayCollection
     * 
     * @ORM\OneToMany(targetEntity="Interest", mappedBy="user", cascade={"remove","persist"})
     */
    private $interest;

    /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="MerITDLC", mappedBy="inge", fetch="EXTRA_LAZY")
     */
    private $merITDLC;


    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct();

        $this->demandepee = new ArrayCollection();
        $this->ingeitdlc = new ArrayCollection();
        $this->preferencemain = new ArrayCollection();
        $this->preferenceselected = new ArrayCollection();
        $this->profitdlc = new ArrayCollection();
        $this->merITDLC = new ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

     /**
      * Get full name: firstname then lastname
      *
      * @return string
      */
    public function getFullName()
    {
        return $this->firstname . ' ' . $this->lastname;
    }

    /**
     * Set firstname
     *
     * @param string $firstname
     *
     * @return User
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;

        return $this;
    }

    /**
     * Get firstname
     *
     * @return string
     */
    public function getFirstname()
    {
        return $this->firstname;
    }

    /**
     * Set lastname
     *
     * @param string $lastname
     *
     * @return User
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;

        return $this;
    }

    /**
     * Get lastname
     *
     * @return string
     */
    public function getLastname()
    {
        return $this->lastname;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     *
     * @return User
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedValue()
    {
        $this->created = new \DateTime();
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set is_active
     *
     * @param bool $isActive
     *
     * @return User
     */
    public function setIsActive($isActive)
    {
        $this->is_active = $isActive;

        return $this;
    }

    /**
     * Get is_active
     *
     * @return boolean
     */
    public function getIsActive()
    {
        return $this->is_active;
    }

    /**
     * Set is_available
     *
     * @param bool $isAvailable
     *
     * @return User
     */
    public function setIsAvailable($isAvailable)
    {
        $this->is_available = $isAvailable;

        return $this;
    }

    /**
     * Get is_available
     *
     * @return boolean
     */
    public function getIsAvailable()
    {
        return $this->is_available;
    }

    /**
     * Set availabilities
     *
     * @param ArrayCollection $availabilities
     *
     * @return User
     */
    public function setAvailabilities($availabilities)
    {
        $this->availabilities = $availabilities;

        return $this;
    }

    /**
     * Get availabilities
     *
     * @return ArrayCollection
     */
    public function getAvailabilities()
    {
        return $this->availabilities;
    }

    /**
     * Set birthday
     *
     * @param \DateTime $birthday
     *
     * @return User
     */
    public function setBirthday($birthday)
    {
        $this->birthday = $birthday;

        return $this;
    }

    /**
     * Get birthday
     *
     * @return \DateTime
     */
    public function getBirthday()
    {
        return $this->birthday;
    }

    /**
     * Set phone
     *
     * @param string $phone
     *
     * @return User
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;

        return $this;
    }

    /**
     * Get phone
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Set mobile
     *
     * @param string $mobile
     *
     * @return User
     */
    public function setMobile($mobile)
    {
        $this->mobile = $mobile;

        return $this;
    }

    /**
     * Get mobile
     *
     * @return string
     */
    public function getMobile()
    {
        return $this->mobile;
    }

    /**
     * Set classrooms
     * Check if the given classrooms are valid (not null) before saving them
     *
     * @param array $classrooms
     *
     * @return User
     */
    public function setClassroom($classrooms = null)
    {
        $this->classroom = implode('|', $classrooms);

        return $this;
    }

    /**
     * Get classroom
     *
     * @return array
     */
    public function getClassroom()
    {
        return explode('|', $this->classroom);
    }

    /**
     * Set category job
     *
     * @param string $categoryJob
     *
     * @return User
     */
    public function setCategoryJob($categoryJob)
    {
        $this->categoryJob = $categoryJob;

        return $this;
    }

    /**
     * Get category job
     *
     * @return string
     */
    public function getCategoryJob()
    {
        return $this->categoryJob;
    }

    /**
     * Set job
     *
     * @param string $job
     *
     * @return User
     */
    public function setJob($job)
    {
        $this->job = $job;

        return $this;
    }

    /**
     * Get job
     *
     * @return string
     */
    public function getJob()
    {
        return $this->job;
    }

    /**
     * Set establishment
     *
     * @param Establishment $establishment
     *
     * @return User
     */
    public function setEstablishment(Establishment $establishment = null)
    {
        $this->establishment = $establishment;

        return $this;
    }

    /**
     * Get establishment
     *
     * @return Establishment
     */
    public function getEstablishment()
    {
        return $this->establishment;
    }

    /**
     * Set establishmentType
     * @param string $establishmentType
     * @return User
     */
    public function setEstablishmentType($establishmentType)
    {
        $this->establishmentType = $establishmentType;

        return $this;
    }

    /**
     * Get establishmentType
     * @return string
     */
    public function getEstablishmentType()
    {
        return $this->establishmentType;
    }

    /**
     * Set establishmentEducation
     * @param string $establishmentEducation
     * @return User
     */
    public function setEstablishmentEducation($establishmentEducation)
    {
        $this->establishmentEducation = $establishmentEducation;

        return $this;
    }

    /**
     * Get establishmentEducation
     * @return string
     */
    public function getEstablishmentEducation()
    {
        return $this->establishmentEducation;
    }

    /**
     * Set establishmentSector
     * @param OperationPEECategory $establishmentSector
     * @return User
     */
    public function setEstablishmentSector($establishmentSector)
    {
        $this->establishmentSector = $establishmentSector;

        return $this;
    }

    /**
     * Get establishmentSector
     * @return OperationPEECategory
     */
    public function getEstablishmentSector()
    {
        return $this->establishmentSector;
    }

    /**
     * Set establishmentSectorOther
     * @param string $establishmentSectorOther
     * @return User
     */
    public function setEstablishmentSectorOther($establishmentSectorOther)
    {
        $this->establishmentSectorOther = $establishmentSectorOther;

        return $this;
    }

    /**
     * Get establishmentSectorOther
     * @return string
     */
    public function getEstablishmentSectorOther()
    {
        return $this->establishmentSectorOther;
    }

    /**
     * Set establishmentName
     * @param string $establishmentName
     * @return User
     */
    public function setEstablishmentName($establishmentName)
    {
        $this->establishmentName = $establishmentName;

        return $this;
    }

    /**
     * Get establishmentName
     * @return string
     */
    public function getEstablishmentName()
    {
        return $this->establishmentName;
    }

    /**
     * Set establishmentZipcode
     *
     * @param int $establishmentZipcode
     *
     * @return User
     */
    public function setEstablishmentZipcode($establishmentZipcode)
    {
        $this->establishmentZipcode = $establishmentZipcode;

        return $this;
    }

    /**
     * Get establishmentZipcode
     *
     * @return integer
     */
    public function getEstablishmentZipcode()
    {
        return $this->establishmentZipcode;
    }

    /**
     * Set establishmentCity
     *
     * @param string $establishmentCity
     *
     * @return User
     */
    public function setEstablishmentCity($establishmentCity)
    {
        $this->establishmentCity = $establishmentCity;

        return $this;
    }

    /**
     * Get establishmentCity
     *
     * @return string
     */
    public function getEstablishmentCity()
    {
        return $this->establishmentCity;
    }

    /**
     * Set personalZipcode
     *
     * @param int $personalZipcode
     *
     * @return User
     */
    public function setPersonalZipcode($personalZipcode)
    {
        $this->personalZipcode = $personalZipcode;

        return $this;
    }

    /**
     * Get personalZipcode
     *
     * @return integer
     */
    public function getPersonalZipcode()
    {
        return $this->personalZipcode;
    }

    /**
     * Set personalCity
     *
     * @param string $personalCity
     *
     * @return User
     */
    public function setPersonalCity($personalCity)
    {
        $this->personalCity = $personalCity;

        return $this;
    }

    /**
     * Get personalCity
     *
     * @return string
     */
    public function getPersonalCity()
    {
        return $this->personalCity;
    }

    /**
     * Set briefing
     *
     * @param string $briefing
     *
     * @return User
     */
    public function setBriefing($briefing)
    {
        $this->briefing = $briefing;

        return $this;
    }

    /**
     * Get briefing
     *
     * @return string
     */
    public function getBriefing()
    {
        return $this->briefing;
    }

    /**
     * Set newsletter
     *
     * @param bool $newsletter
     *
     * @return User
     */
    public function setNewsletter($newsletter)
    {
        $this->newsletter = $newsletter;

        return $this;
    }

    /**
     * Get newsletter
     *
     * @return boolean
     */
    public function getNewsletter()
    {
        return $this->newsletter;
    }

    /**
     * Set nbContribution
     *
     * @param int $nbContribution
     *
     * @return User
     */
    public function setNbContribution($nbContribution)
    {
        $this->nbContribution = $nbContribution;

        return $this;
    }

    /**
     * Get nbContribution
     *
     * @return integer
     */
    public function getNbContribution()
    {
        return $this->nbContribution;
    }

    /**
     * Set formation
     *
     * @param string $formation
     *
     * @return User
     */
    public function setFormation($formation)
    {
        $this->formation = $formation;

        return $this;
    }

    /**
     * Get formation
     *
     * @return string
     */
    public function getFormation()
    {
        return $this->formation;
    }

    /**
     * Set formationType
     *
     * @param string $formationType
     *
     * @return User
     */
    public function setFormationType($formationType)
    {
        $this->formationType = $formationType;

        return $this;
    }

    /**
     * Get formationType
     *
     * @return string
     */
    public function getFormationType()
    {
        return $this->formationType;
    }

    /**
     * Set detailFormation
     *
     * @param string $detailFormation
     *
     * @return User
     */
    public function setDetailFormation($detailFormation)
    {
        $this->detailFormation = $detailFormation;

        return $this;
    }

    /**
     * Get detailFormation
     *
     * @return string
     */
    public function getDetailFormation()
    {
        return $this->detailFormation;
    }

    /**
     * Set aboutMe
     *
     * @param string $aboutMe
     *
     * @return User
     */
    public function setAboutMe($aboutMe)
    {
        $this->aboutMe = $aboutMe;

        return $this;
    }

    /**
     * Get aboutMe
     *
     * @return string
     */
    public function getAboutMe()
    {
        return $this->aboutMe;
    }

    /**
     * Set publicTransport
     *
     * @param bool $publicTransport
     *
     * @return User
     */
    public function setPublicTransport($publicTransport)
    {
        $this->publicTransport = $publicTransport;

        return $this;
    }

    /**
     * Get publicTransport
     *
     * @return boolean
     */
    public function getPublicTransport()
    {
        return $this->publicTransport;
    }

    /**
     * Set transportTime
     *
     * @param int $transportTime
     *
     * @return User
     */
    public function setTransportTime($transportTime)
    {
        $this->transportTime = $transportTime;

        return $this;
    }

    /**
     * Get transportTime
     *
     * @return integer
     */
    public function getTransportTime()
    {
        return $this->transportTime;
    }

    /**
     * Set academy
     *
     * @param string $academy
     *
     * @return User
     */
    public function setAcademy($academy)
    {
        $this->academy = $academy;

        return $this;
    }

    /**
     * Get academy
     *
     * @return string
     */
    public function getAcademy()
    {
        return $this->academy;
    }

    /**
     * Set rep
     *
     * @param string $rep
     *
     * @return User
     */
    public function setRep($rep = null)
    {
        $this->rep = $rep;

        return $this;
    }

    /**
     * Get rep
     *
     * @return string
     */
    public function getRep()
    {
        return $this->rep;
    }

    /**
     * Set shoeSize
     *
     * @param int $shoeSize
     *
     * @return User
     */
    public function setShoeSize($shoeSize)
    {
        $this->shoeSize = $shoeSize;

        return $this;
    }

    /**
     * Get shoeSize
     *
     * @return integer
     */
    public function getShoeSize()
    {
        return $this->shoeSize;
    }

    /**
     * Set type
     *
     * @param string $type
     *
     * @return User
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set establishmentAddress
     *
     * @param string $establishmentAddress
     *
     * @return User
     */
    public function setEstablishmentAddress($establishmentAddress)
    {
        $this->establishmentAddress = $establishmentAddress;

        return $this;
    }

    /**
     * Get establishmentAddress
     *
     * @return string
     */
    public function getEstablishmentAddress()
    {
        return $this->establishmentAddress;
    }

    /**
     * Set personalAddress
     *
     * @param string $personalAddress
     *
     * @return User
     */
    public function setPersonalAddress($personalAddress)
    {
        $this->personalAddress = $personalAddress;

        return $this;
    }

    /**
     * Get personalAddress
     *
     * @return string
     */
    public function getPersonalAddress()
    {
        return $this->personalAddress;
    }

    /**
     * Set personalLatitude
     *
     * @param float $personalLatitude
     *
     * @return User
     */
    public function setPersonalLatitude($personalLatitude)
    {
        $this->personalLatitude = $personalLatitude;

        return $this;
    }

    /**
     * Get personalLatitude
     *
     * @return float
     */
    public function getPersonalLatitude()
    {
        return $this->personalLatitude;
    }

    /**
     * Set personalLongitude
     *
     * @param float $personalLongitude
     *
     * @return User
     */
    public function setPersonalLongitude($personalLongitude)
    {
        $this->personalLongitude = $personalLongitude;

        return $this;
    }

    /**
     * Get personalLongitude
     *
     * @return float
     */
    public function getPersonalLongitude()
    {
        return $this->personalLongitude;
    }

    /**
     * Set professionalDiscover
     *
     * @param bool $professionalDiscover
     *
     * @return User
     */
    public function setProfessionalDiscover($professionalDiscover)
    {
        $this->professionalDiscover = $professionalDiscover;

        return $this;
    }

    /**
     * Get professionalDiscover
     *
     * @return boolean
     */
    public function getProfessionalDiscover()
    {
        return $this->professionalDiscover;
    }

    /**
     * Add demandepee
     *
     * @param DemandePEE $demandepee
     *
     * @return User
     */
    public function addDemandepee(DemandePEE $demandepee)
    {
        $this->demandepee[] = $demandepee;

        return $this;
    }

    /**
     * Remove demandepee
     *
     * @param DemandePEE $demandepee
     */
    public function removeDemandepee(DemandePEE $demandepee)
    {
        $this->demandepee->removeElement($demandepee);
    }

    /**
     * Get demandepee
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDemandepee()
    {
        return $this->demandepee;
    }

    /**
     * Set profitdlc
     *
     * @param OperationITDLC $profitdlc
     *
     * @return User
     */
    public function setProfitdlc(OperationITDLC $profitdlc = null)
    {
        $this->profitdlc = $profitdlc;

        return $this;
    }

    /**
     * Get profitdlc
     *
     * @return ArrayCollection
     */
    public function getProfitdlc()
    {
        return $this->profitdlc;
    }

    /**
     * Set ingeitdlc
     *
     * @param OperationITDLC $ingeitdlc
     *
     * @return User
     */
    public function setIngeitdlc(OperationITDLC $ingeitdlc = null)
    {
        $this->ingeitdlc = $ingeitdlc;

        return $this;
    }

    /**
     * Get ingeitdlc
     *
     * @return ArrayCollection
     */
    public function getIngeitdlc()
    {
        return $this->ingeitdlc;
    }

    /**
     * Set latitude
     *
     * @param float $latitude
     *
     * @return User
     */
    public function setLatitude($latitude)
    {
        $this->latitude = $latitude;

        return $this;
    }

    /**
     * Get latitude
     *
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * Set longitude
     *
     * @param float $longitude
     *
     * @return User
     */
    public function setLongitude($longitude)
    {
        $this->longitude = $longitude;

        return $this;
    }

    /**
     * Get longitude
     *
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * Set honorific
     *
     * @param int $honorific
     *
     * @return User
     */
    public function setHonorific($honorific)
    {
        $this->honorific = $honorific;

        return $this;
    }

    /**
     * Get honorific
     *
     * @return int
     */
    public function getHonorific()
    {
        return $this->honorific;
    }

    /**
     * Set expectations
     *
     * @param int $expectations
     *
     * @return User
     */
    public function setExpectations($expectations)
    {
        $this->expectations = $expectations;

        return $this;
    }

    /**
     * Get expectations
     *
     * @return int
     */
    public function getExpectations()
    {
        return $this->expectations;
    }

    /**
     * Set identityCard
     *
     * @param string $identityCard
     *
     * @return User
     */
    public function setIdentityCard($identityCard)
    {
        $this->identityCard = $identityCard;

        return $this;
    }

    /**
     * Get identityCard
     *
     * @return string
     */
    public function getIdentityCard()
    {
        return $this->identityCard;
    }

    /**
     * Get photograph
     *
     * @return string
     */
    public function getPhotograph()
    {
        return $this->photograph;
    }

    /**
     * Set photograph
     *
     * @param bool $photograph
     *
     * @return User
     */
    public function setPhotograph($photograph)
    {
        $this->photograph = $photograph;

        return $this;
    }

    /**
     * Get photo
     *
     * @return boolean
     */
    public function getPhoto()
    {
        return $this->photo;
    }

    /**
     * Set photo
     *
     * @param string $photo
     *
     * @return User
     */
    public function setPhoto($photo)
    {
        $this->photo = $photo;

        return $this;
    }

    /**
     * Get photoFile
     *
     * @return UploadedFile
     */
    public function getPhotoFile()
    {
        return $this->photoFile;
    }


    /**
     * Sets photoFile.
     *
     * @param UploadedFile $photoFile
     */
    public function setPhotoFile(UploadedFile $photoFile = null)
    {
        $this->photoFile = $photoFile;

        // check if we have an old image path
        if (is_file($this->getAbsolutePhoto())) {
            // store the old name to delete after the update
            $this->photoTemp = $this->getAbsolutePhoto();
        } else {
            $this->photo = null;
        }
    }

    /**
     * Add profitdlc
     *
     * @param OperationITDLC $profitdlc
     *
     * @return User
     */
    public function addProfitdlc(OperationITDLC $profitdlc)
    {
        $this->profitdlc[] = $profitdlc;

        return $this;
    }

    /**
     * Remove profitdlc
     *
     * @param OperationITDLC $profitdlc
     */
    public function removeProfitdlc(OperationITDLC $profitdlc)
    {
        $this->profitdlc->removeElement($profitdlc);
    }

    /**
     * Add ingeitdlc
     *
     * @param OperationITDLC $ingeitdlc
     *
     * @return User
     */
    public function addIngeitdlc(OperationITDLC $ingeitdlc)
    {
        $this->ingeitdlc[] = $ingeitdlc;

        return $this;
    }

    /**
     * Remove ingeitdlc
     *
     * @param OperationITDLC $ingeitdlc
     */
    public function removeIngeitdlc(OperationITDLC $ingeitdlc)
    {
        $this->ingeitdlc->removeElement($ingeitdlc);
    }

    /**
     * Set isValideInfo
     *
     * @param bool $isValideInfo
     *
     * @return User
     */
    public function setIsValideInfo($isValideInfo)
    {
        $this->isValideInfo = $isValideInfo;

        return $this;
    }

    /**
     * Get isValideInfo
     *
     * @return boolean
     */
    public function getIsValideInfo()
    {
        return $this->isValideInfo;
    }

    /**
     * Set sendCard
     *
     * @param string $sendCard
     *
     * @return User
     */
    public function setSendCard($sendCard)
    {
        $this->sendCard = $sendCard;

        return $this;
    }

    /**
     * Get sendCard
     *
     * @return string
     */
    public function getSendCard()
    {
        return $this->sendCard;
    }

    /**
     * Set identityCard1
     *
     * @param string $identityCard1
     *
     * @return User
     */
    public function setIdentityCard1($identityCard1)
    {
        $this->identityCard1 = $identityCard1;

        return $this;
    }

    /**
     * Get identityCard1
     *
     * @return string
     */
    public function getIdentityCard1()
    {
        return $this->identityCard1;
    }

    /**
     * Set identityCard2
     *
     * @param string $identityCard2
     *
     * @return User
     */
    public function setIdentityCard2($identityCard2)
    {
        $this->identityCard2 = $identityCard2;

        return $this;
    }

    /**
     * Get identityCard2
     *
     * @return string
     */
    public function getIdentityCard2()
    {
        return $this->identityCard2;
    }

    /********************************************************/
    private $temp;
    private $tempDocument;

    private $file;
    private $fileDocument;

    /***********************************************************/
    /**
     * Sets file.
     *
     * @param UploadedFile $file
     */
    public function setFile(UploadedFile $file = null)
    {
        $this->file = $file;

        // check if we have an old image path
        if (is_file($this->getAbsoluteIdentityCard1())) {
            // store the old name to delete after the update
            $this->temp = $this->getAbsoluteIdentityCard1();
        } else {
            $this->identityCard1 = null;
        }
    }

    /**
     * Sets fileDocument.
     *
     * @param UploadedFile $fileDocument
     */
    public function setFileDocument(UploadedFile $fileDocument = null)
    {
        $this->fileDocument = $fileDocument;

        // check if we have an old image path
        if (is_file($this->getAbsoluteIdentityCard2())) {
            // store the old name to delete after the update
            $this->tempDocument = $this->getAbsoluteIdentityCard2();
        } else {
            $this->identityCard2 = null;
        }
    }

    /**
     * Get file.
     *
     * @return UploadedFile
     */
    public function getFile()
    {
        return $this->file;
    }

    /**
     * Get fileDocument.
     *
     * @return UploadedFile
     */
    public function getFileDocument()
    {
        return $this->fileDocument;
    }

    public function getAbsoluteIdentityCard1()
    {
        return null === $this->identityCard1
            ? null
            : $this->getUploadIdentityCardRootDir().'/'.$this->identityCard1;
    }

    public function getAbsoluteIdentityCard2()
    {
        return null === $this->identityCard2
            ? null
            : $this->getUploadIdentityCardRootDir().'/'.$this->identityCard2;
    }

    protected function getUploadIdentityCardRootDir()
    {
        return __DIR__.'/../../../app/Resources/'.$this->getUploadIdentityCardDir();
    }

    protected function getUploadIdentityCardDir()
    {
        return 'uploads/user/ci';
    }

    /*
     * Fonctions relatives à l'upload de la photo de l'utilisateur
     */
    public function getAbsolutePhoto()
    {
        return null === $this->photo
            ? null
            : $this->getUploadPhotoRootDir().'/'.$this->id.'.'.$this->photo;
    }

    public function getWebPhoto()
    {
        return null === $this->photo
            ? null
            : $this->getUploadPhotoDir().'/'.$this->id.'.'.$this->photo;
    }

    public function getUploadPhotoRootDir()
    {
        return __DIR__.'/../../../web/'.$this->getUploadPhotoDir();
    }

    protected function getUploadPhotoDir()
    {
        return 'uploads/user/photo';
    }

    public function uploadPhotoFile()
    {
        if (null === $this->getPhotoFile()) {
            return;
        }

        // check if we have an old image
        if (isset($this->photoTemp)) {
            unlink($this->photoTemp);
            $this->photoTemp = null;
        }

        $this->getPhotoFile()->move(
            $this->getUploadPhotoRootDir(),
            $this->getId().'.'.$this->getPhotoFile()->guessExtension()
        );

        $this->setPhotoFile(null);
    }

    /**
     * @ORM\PrePersist()
     * @ORM\PreUpdate()
     */
    public function preUpload()
    {
        if (null !== $this->getFile()) {
            $this->identityCard1 = $this->getId().'-'.$this->getFile()->getClientOriginalName();
        }

        if (null !== $this->getFileDocument()) {
            $this->identityCard2 = $this->getId().'-'.$this->getFileDocument()->getClientOriginalName();
        }

        if (null !== $this->getPhotoFile()) {
            $this->photo = $this->getPhotoFile()->guessExtension();
        }
    }

    public function uploadFile()
    {
        if (null === $this->getFile()) {
            return;
        }

        // check if we have an old image
        if (isset($this->temp)) {
            unlink($this->temp);
            $this->temp = null;
        }

        $this->getFile()->move(
            $this->getUploadIdentityCardRootDir(),
            $this->getId().'-'.$this->getFile()->getClientOriginalName()
        );

        $this->setFile(null);
    }

    public function uploadFileDocument()
    {
        if (null === $this->getFileDocument()) {
            return;
        }

        if (isset($this->tempDocument)) {
            // delete the old image
            unlink($this->tempDocument);
            // clear the temp image path
            $this->tempDocument = null;
        }

        $this->getFileDocument()->move(
            $this->getUploadIdentityCardRootDir(),
            $this->getId().'-'.$this->getFileDocument()->getClientOriginalName()
        );

        $this->setFileDocument(null);
    }

    /**
     * @ORM\PostPersist()
     * @ORM\PostUpdate()
     */
    public function upload()
    {
        $this->uploadFile();
        $this->uploadFileDocument();
        $this->uploadPhotoFile();
    }

    /**
     * @ORM\PreRemove()
     */
    public function storeFilenameForRemove()
    {
        $this->temp = $this->getAbsoluteIdentityCard1();
        $this->tempDocument = $this->getAbsoluteIdentityCard2();
        $this->photoTemp = $this->getAbsolutePhoto();
    }

    /**
     * @ORM\PostRemove()
     */
    public function removeUpload()
    {
        if (isset($this->temp)) {
            unlink($this->temp);
        }

        if (isset($this->tempDocument)) {
            unlink($this->tempDocument);
        }

        $this->removePhoto();
    }

    public function removePhoto()
    {
        $fileRemoved = false;

        if (is_file($this->getAbsolutePhoto())) {
            $fileRemoved = unlink($this->getAbsolutePhoto());
        }

        $this->photo = null;

        return $fileRemoved;
    }

    /**
     * Set jobOther
     *
     * @param string $jobOther
     *
     * @return User
     */
    public function setJobOther($jobOther)
    {
        $this->jobOther = $jobOther;

        return $this;
    }

    /**
     * Get jobOther
     *
     * @return string
     */
    public function getJobOther()
    {
        return $this->jobOther;
    }

    /**
     * Set bossEmail
     *
     * @param string $bossEmail
     *
     * @return User
     */
    public function setBossEmail($bossEmail)
    {
        $this->bossEmail = $bossEmail;

        return $this;
    }

    /**
     * Get bossEmail
     *
     * @return string
     */
    public function getBossEmail()
    {
        return $this->bossEmail;
    }

    /**
     * Set establishmentEmail
     *
     * @param string $establishmentEmail
     *
     * @return User
     */
    public function setEstablishmentEmail($establishmentEmail)
    {
        $this->establishmentEmail = $establishmentEmail;

        return $this;
    }

    /**
     * Get establishmentEmail
     *
     * @return string
     */
    public function getEstablishmentEmail()
    {
        return $this->establishmentEmail;
    }

    /**
     * Add preferencemain
     *
     * @param Preference $preferencemain
     *
     * @return User
     */
    public function addPreferencemain(Preference $preferencemain)
    {
        $this->preferencemain[] = $preferencemain;

        return $this;
    }

    /**
     * Remove preferencemain
     *
     * @param Preference $preferencemain
     */
    public function removePreferencemain(Preference $preferencemain)
    {
        $this->preferencemain->removeElement($preferencemain);
    }

    /**
     * Get preferencemain
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPreferencemain()
    {
        return $this->preferencemain;
    }

    /**
     * Add preferenceselected
     *
     * @param Preference $preferenceselected
     *
     * @return User
     */
    public function addPreferenceselected(Preference $preferenceselected)
    {
        $this->preferenceselected[] = $preferenceselected;

        return $this;
    }

    /**
     * Remove preferenceselected
     *
     * @param Preference $preferenceselected
     */
    public function removePreferenceselected(Preference $preferenceselected)
    {
        $this->preferenceselected->removeElement($preferenceselected);
    }

    /**
     * Get preferenceselected
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPreferenceselected()
    {
        return $this->preferenceselected;
    }

    /**
     * Set note
     *
     * @param string $note
     *
     * @return User
     */
    public function setNote($note)
    {
        $this->note = $note;

        return $this;
    }

    /**
     * Get note
     *
     * @return string
     */
    public function getNote()
    {
        return $this->note;
    }

    /**
     * Set transportKm
     *
     * @param int $transportKm
     *
     * @return User
     */
    public function setTransportKm($transportKm)
    {
        $this->transportKm = $transportKm;

        return $this;
    }

    /**
     * Get transportKm
     *
     * @return integer
     */
    public function getTransportKm()
    {
        return $this->transportKm;
    }

    /**
     * Set importId
     *
     * @param int $importId
     *
     * @return User
     */
    public function setImportId($importId)
    {
        $this->importId = $importId;

        return $this;
    }

    /**
     * Get importId
     *
     * @return integer
     */
    public function getImportId()
    {
        return $this->importId;
    }

    /**
     * Set establishmentNameOther
     *
     * @param string $establishmentNameOther
     * @return User
     */
    public function setEstablishmentNameOther($establishmentNameOther = null)
    {
        // if (null !== $establishmentNameOther) {
        //     $this->establishmentName = $establishmentNameOther;
        // }

        $this->establishmentNameOther = $establishmentNameOther;

        return $this;
    }

    /**
     * Get establishmentNameOther
     *
     * @return string
     */
    public function getEstablishmentNameOther()
    {
        return $this->establishmentNameOther;
    }

    /**
     * Set importIdProfessor
     *
     * @param int $importIdProfessor
     *
     * @return User
     */
    public function setImportIdProfessor($importIdProfessor)
    {
        $this->importIdProfessor = $importIdProfessor;

        return $this;
    }

    /**
     * Get importIdProfessor
     *
     * @return integer
     */
    public function getImportIdProfessor()
    {
        return $this->importIdProfessor;
    }

    /**
     * Set importIdEnginner
     *
     * @param int $importIdEnginner
     *
     * @return User
     */
    public function setImportIdEnginner($importIdEnginner)
    {
        $this->importIdEnginner = $importIdEnginner;

        return $this;
    }

    /**
     * Get importIdEnginner
     *
     * @return integer
     */
    public function getImportIdEnginner()
    {
        return $this->importIdEnginner;
    }

    /**
     * Set clearPassword
     *
     * @param string $clearPassword
     *
     * @return User
     */
    public function setClearPassword($clearPassword)
    {
        $this->clearPassword = $clearPassword;

        return $this;
    }

    /**
     * Get clearPassword
     *
     * @return string
     */
    public function getClearPassword()
    {
        return $this->clearPassword;
    }

    /**
     * @return array
     */
    public function getTranslatedData()
    {
        $data = array(
            'job' => '',
            'publicTransport' => '',
            'transportKm' => '',
            'transportTime' => '',
        );

        if (!empty($this->job)) {
            $data['job'] = 'word.' . strtolower($this->type) . '.userJob.' .$this->job . '.label';
        }

        if (!empty($this->categoryJob)) {
            $data['categoryJob'] = 'word.category.userJob' . ucfirst(strtolower($this->type)) . '.' .$this->categoryJob . '.label';
        }
        
        $transportTypeOptions = UserHelper::getTransportTypeOptions();
        if (!empty($this->publicTransport) && array_key_exists((int) $this->publicTransport, $transportTypeOptions)) {
            $data['publicTransport'] = $transportTypeOptions[(int) $this->publicTransport];
        }

        $transportDistanceOptions = UserHelper::getTransportDistanceOptions();
        if (!empty($this->transportKm) && array_key_exists($this->transportKm, $transportDistanceOptions)) {
            $data['transportKm'] = $transportDistanceOptions[$this->transportKm];
        }

        $transportTimeOptions = UserHelper::getTransportTimeOptions();
        if (!empty($this->transportTime) && array_key_exists($this->transportTime, $transportTimeOptions)) {
            $data['transportTime'] = $transportTimeOptions[$this->transportTime];
        }
        
        return $data;
    }

    /**
     * Indicates if a user can be deleted.
     * This method takes advantages of the fetch="EXTRA_LAZY" Doctrine annotation, using only count() on ArrayCollection.
     * @see http://docs.doctrine-project.org/projects/doctrine-orm/en/latest/tutorials/extra-lazy-associations.html Extra Lazy Associations
     * @return boolean
     */
    public function isDeletable()
    {
        return
            0 === $this->getDemandepee()->count()
            && (
                UserType::TEACHER === $this->getType() && 0 === count($this->getProfitdlc())
                || UserType::ENGINEER === $this->getType() && 0 === count($this->getIngeitdlc())
            )
        ;
    }

    /**
     * Vérifie que les deux pièces d'identité ont été saisies,
     * dans le cas où l'utilisateur a choisi de transmettre sa pièce d'identité par voie électronique.
     *
     * @param ExecutionContextInterface $context
     */
    public function areIdentityCardsValid(ExecutionContextInterface $context)
    {
        // if ('digitale' === $this->getSendCard()) {
            $file = $this->getFile();   // Recto: fichier indiqué dans le champ <input type="file"/>
            $fileDocument = $this->getFileDocument();   // Verso: fichier indiqué dans le champ <input type="file"/>
            $ic1 = $this->getIdentityCard1();   // Recto: fichier existant
            $ic2 = $this->getIdentityCard2();   // Verso: fichier existant

            $ic1_exists = null === $file && null === $ic1 ? false : true;
            $ic2_exists = null === $fileDocument && null === $ic2 ? false : true;
            /*
            if (!$ic1_exists) {   // Ni recto
                $context->buildViolation("Vous avez oublié dʼajouter votre pièce d'identité.")
                    ->atPath('file')
                    ->addViolation();
            }

            if (!$ic2_exists) {   // Ni verso
                $context->buildViolation("Vous avez oublié dʼajouter votre pièce d'identité.")
                    ->atPath('fileDocument')
                    ->addViolation();
            }
            */
        // }
    }

    /**
     * Vérifie qu'un métier a bien été spécifié
     *
     * @param ExecutionContextInterface $context
     */
    public function isJobEmpty(ExecutionContextInterface $context)
    {
        if (UserType::TEACHER === $this->getType()) {
            // Ne pas faire de comparaison sur le type (pas de === ) !
            if (false == $this->getJob() && false == $this->getJobOther()) {
                $context->buildViolation("Vous avez oublié dʼindiquer votre métier.")
                    ->atPath('job')
                    ->addViolation();
            }
        }
    }

    /**
     * Vérifie qu'un établissement a bien été spécifié
     *
     * @param ExecutionContextInterface $context
     */
    public function isEstablishmentEmpty(ExecutionContextInterface $context)
    {
        $errorMessage = "Vous avez oublié de préciser le nom de votre ";

        if (!$this->getEstablishmentName() && !$this->getEstablishmentNameOther()) {
            if (UserType::TEACHER === $this->getType()) {
                $errorMessage .= "établissement.";

                $context->buildViolation($errorMessage)
                        ->atPath('establishmentName')
                        ->addViolation();
            } elseif (UserType::ENGINEER === $this->getType() && !($this->getEstablishment() instanceof Establishment)) {
                $errorMessage .= "entreprise...";

                $context->buildViolation($errorMessage)
                        ->atPath('establishment')
                        ->addViolation();
            }
        }
    }


    /**
     * Vérifie qu'un secteur d'activité a bien été spécifié
     *
     * @param ExecutionContextInterface $context
     */
    public function isEstablishmentSectorEmpty(ExecutionContextInterface $context)
    {
        $errorMessage = "Vous devez préciser le secteur d'activité";

        if (!$this->getEstablishmentSector() && !$this->getEstablishmentSectorOther()) {
            $context->buildViolation($errorMessage)
                    ->atPath('establishmentSector')
                    ->addViolation();
            
        }
    }

    /**
     * Update Academy
     * Mapping Academy with Zipcode
     *
     * @param ExecutionContextInterface $context
     */
    public function updateAcademy(ExecutionContextInterface $context)
    {
        $zipcode = $this->getEstablishmentZipcode();
        
        if (
            UserType::TEACHER === $this->getType()
            && !empty($zipcode)
        ) {
            $academies = UserHelper::getAcademyList();

            if (
                preg_match("/^(04|05|13|84)\d{3}/", $zipcode)
                && isset($academies["Aix-Marseille"])
            ) {
                $this->setAcademy($academies["Aix-Marseille"]);
            }
            elseif (
                preg_match("/^(02|60|80)\d{3}/", $zipcode)
                && isset($academies["Amiens"])
            ) {
                $this->setAcademy($academies["Amiens"]);
            }
            elseif (
                preg_match("/^(25|39|70|90)\d{3}/", $zipcode)
                && isset($academies["Besançon"])
            ) {
                $this->setAcademy($academies["Besançon"]);
            }
            elseif (
                preg_match("/^(24|33|40|47|64)\d{3}/", $zipcode)
                && isset($academies["Bordeaux"])
            ) {
                $this->setAcademy($academies["Bordeaux"]);
            }
            elseif (
                preg_match("/^(14|50|61)\d{3}/", $zipcode)
                && isset($academies["Caen"])
            ) {
                $this->setAcademy($academies["Caen"]);
            }
            elseif (
                preg_match("/^(2A|2B|20)\d{3,4}/", $zipcode)
                && isset($academies["Corse"])
            ) {
                $this->setAcademy($academies["Corse"]);
            }
            elseif (
                preg_match("/^(03|15|43|63)\d{3}/", $zipcode)
                && isset($academies["Clermont-Ferrand"])
            ) {
                $this->setAcademy($academies["Clermont-Ferrand"]);
            }
            elseif (
                preg_match("/^(77|93|94)\d{3}/", $zipcode)
                && isset($academies["Créteil"])
            ) {
                $this->setAcademy($academies["Créteil"]);
            }
            elseif (
                preg_match("/^(21|58|71|89)\d{3}/", $zipcode)
                && isset($academies["Dijon"])
            ) {
                $this->setAcademy($academies["Dijon"]);
            }
            elseif (
                preg_match("/^(07|26|38|73|74)\d{3}/", $zipcode)
                && isset($academies["Grenoble"])
            ) {
                $this->setAcademy($academies["Grenoble"]);
            }
            elseif (
                preg_match("/^(59|62)\d{3}/", $zipcode)
                && isset($academies["Lille"])
            ) {
                $this->setAcademy($academies["Lille"]);
            }
            elseif (
                preg_match("/^(19|23|87)\d{3}/", $zipcode)
                && isset($academies["Limoges"])
            ) {
                $this->setAcademy($academies["Limoges"]);
            }
            elseif (
                preg_match("/^(01|42|69)\d{3}/", $zipcode)
                && isset($academies["Lyon"])
            ) {
                $this->setAcademy($academies["Lyon"]);
            }
            elseif (
                preg_match("/^(11|30|34|48|66)\d{3}/", $zipcode)
                && isset($academies["Montpellier"])
            ) {
                $this->setAcademy($academies["Montpellier"]);
            }
            elseif (
                preg_match("/^(54|55|57|88)\d{3}/", $zipcode)
                && isset($academies["Nancy-Metz"])
            ) {
                $this->setAcademy($academies["Nancy-Metz"]);
            }
            elseif (
                preg_match("/^(44|49|53|72|85)\d{3}/", $zipcode)
                && isset($academies["Nantes"])
            ) {
                $this->setAcademy($academies["Nantes"]);
            }
            elseif (
                preg_match("/^(06|83)\d{3}/", $zipcode)
                && isset($academies["Nice"])
            ) {
                $this->setAcademy($academies["Nice"]);
            }
            elseif (
                preg_match("/^(18|28|36|37|41|45)\d{3}/", $zipcode)
                && isset($academies["Orléans-Tours"])
            ) {
                $this->setAcademy($academies["Orléans-Tours"]);
            }
            elseif (
                preg_match("/^(75)\d{3}/", $zipcode)
                && isset($academies["Paris"])
            ) {
                $this->setAcademy($academies["Paris"]);
            }
            elseif (
                preg_match("/^(16|17|79|86)\d{3}/", $zipcode)
                && isset($academies["Poitiers"])
            ) {
                $this->setAcademy($academies["Poitiers"]);
            }
            elseif (
                preg_match("/^(08|10|51|52)\d{3}/", $zipcode)
                && isset($academies["Reims"])
            ) {
                $this->setAcademy($academies["Reims"]);
            }
            elseif (
                preg_match("/^(22|29|35|56)\d{3}/", $zipcode)
                && isset($academies["Rennes"])
            ) {
                $this->setAcademy($academies["Rennes"]);
            }
            elseif (
                preg_match("/^(27|76)\d{3}/", $zipcode)
                && isset($academies["Rouen"])
            ) {
                $this->setAcademy($academies["Rouen"]);
            }
            elseif (
                preg_match("/^(67|68)\d{3}/", $zipcode)
                && isset($academies["Strasbourg"])
            ) {
                $this->setAcademy($academies["Strasbourg"]);
            }
            elseif (
                preg_match("/^(09|12|31|32|46|65|81|82)\d{3}/", $zipcode)
                && isset($academies["Toulouse"])
            ) {
                $this->setAcademy($academies["Toulouse"]);
            }
            elseif (
                preg_match("/^(78|91|92|95)\d{3}/", $zipcode)
                && isset($academies["Versailles"])
            ) {
                $this->setAcademy($academies["Versailles"]);
            }
            elseif (
                preg_match("/^(971)\d{2,3}/", $zipcode)
                && isset($academies["Guadeloupe"])
            ) {
                $this->setAcademy($academies["Guadeloupe"]);
            }
            elseif (
                preg_match("/^(972)\d{2,3}/", $zipcode)
                && isset($academies["Martinique"])
            ) {
                $this->setAcademy($academies["Martinique"]);
            }
            elseif (
                preg_match("/^(973)\d{2,3}/", $zipcode)
                && isset($academies["Guyane"])
            ) {
                $this->setAcademy($academies["Guyane"]);
            }
            elseif (
                preg_match("/^(974)\d{2,3}/", $zipcode)
                && isset($academies["La Réunion"])
            ) {
                $this->setAcademy($academies["La Réunion"]);
            }
            elseif (
                preg_match("/^(975)\d{2,3}/", $zipcode)
                && isset($academies["Saint-Pierre et Miquelon"])
            ) {
                $this->setAcademy($academies["Saint-Pierre et Miquelon"]);
            }
            elseif (
                preg_match("/^(976)\d{2,3}/", $zipcode)
                && isset($academies["Mayotte"])
            ) {
                $this->setAcademy($academies["Mayotte"]);
            }
            elseif (
                preg_match("/^(987)\d{2,3}/", $zipcode)
                && isset($academies["Polynésie-française"])
            ) {
                $this->setAcademy($academies["Polynésie-française"]);
            }
            elseif (
                preg_match("/^(988)\d{2,3}/", $zipcode)
                && isset($academies["Nouvelle-Calédonie"])
            ) {
                $this->setAcademy($academies["Nouvelle-Calédonie"]);
            }
            else {
                $context->buildViolation("Ce code postal n'est associé à aucune Académie")
                        ->atPath('establishmentZipcode')
                        ->addViolation();
            }
        }
    }

    /**
     * Add interest
     *
     * @param Interest $interest
     * @return User
     */
    public function addInterest(Interest $interest)
    {
        $this->interest[] = $interest;
        $interest->setUser($this);

        return $this;
    }

    /**
     * Remove interest
     *
     * @param Interest $interest
     */
    public function removeInterest(Interest $interest)
    {
        $this->interest->removeElement($interest);
    }

    /**
     * Get interest
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getInterest()
    {
        return $this->interest;
    }

    /**
     * Get MerITDLC
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMerITDLC()
    {
        return $this->merITDLC;
    }

    /**
     * @return int
     */
    public function getNumberNoAnswer()
    {
        return $this->numberNoAnswer;
    }

    /**
     * @param int $numberNoAnswer
     */
    public function setNumberNoAnswer($numberNoAnswer)
    {
        $this->numberNoAnswer = $numberNoAnswer;
    }

    /**
     * @return \DateTime
     */
    public function getIdentityCardValidity()
    {
        return $this->identityCardValidity;
    }

    /**
     * @param \DateTime $identityCardValidity
     */
    public function setIdentityCardValidity($identityCardValidity)
    {
        $this->identityCardValidity = $identityCardValidity;
    }
}
