<?php

namespace AppBundle\Entity;

use AppBundle\Entity\SMS;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * SMSCampaign
 * 
 * @ORM\Table(name="sms_campaign")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\SMSCampaignRepository")
 * @ORM\InheritanceType("SINGLE_TABLE")
 * @ORM\DiscriminatorColumn(name="type", type="string")
 * @ORM\DiscriminatorMap({"pee" = "SMSCampaignPEE"})
 * @ORM\HasLifecycleCallbacks
 */
abstract class SMSCampaign
{
    const STATE_IN_PROGRESS = 0;
    const STATE_SENDED = 1;
    const STATE_ERROR = -1;
    
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var string
     *
     * @ORM\Column(name="content", type="text")
     */
    protected $content;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created", type="datetime")
     */
    protected $created;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="updated", type="datetime", nullable=true)
     */
    protected $updated;

    /**
     * @var int
     *
     * @ORM\Column(name="sended", type="integer")
     */
    protected $sended = self::STATE_IN_PROGRESS;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="sended_date_start", type="datetime", nullable=true)
     */
    protected $sendedDateStart;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="sended_date_end", type="datetime", nullable=true)
     */
    protected $sendedDateEnd;


    /**
     * @ORM\OneToMany(targetEntity="SMS", mappedBy="campaign", cascade={"remove", "persist"})
     */
    protected $children;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->children = new ArrayCollection();
    }

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set content.
     *
     * @param string $content
     *
     * @return SMSCampaign
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }

    /**
     * Get content.
     *
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Set created.
     *
     * @param \DateTime $created
     *
     * @return SMSCampaign
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedValue()
    {
        $this->created = new \DateTime();
    }

    /**
     * Get created.
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated.
     *
     * @param \DateTime|null $updated
     *
     * @return SMSCampaign
     */
    public function setUpdated($updated = null)
    {
        $this->updated = $updated;

        return $this;
    }

    /**
     * @ORM\PostPersist
     */
    public function setUpdatedValue()
    {
        $this->updated = new \DateTime();
    }

    /**
     * Get updated.
     *
     * @return \DateTime|null
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * Set sended.
     *
     * @param int $sended
     *
     * @return SMSCampaign
     */
    public function setSended($sended)
    {
        $this->sended = $sended;

        return $this;
    }

    /**
     * Get sended.
     *
     * @return int
     */
    public function getSended()
    {
        return $this->sended;
    }

    /**
     * Set sendedDateStart.
     *
     * @param \DateTime|null $sendedDateStart
     *
     * @return SMSCampaign
     */
    public function setSendedDateStart($sendedDateStart = null)
    {
        $this->sendedDateStart = $sendedDateStart;

        return $this;
    }

    /**
     * Get sendedDateStart.
     *
     * @return \DateTime|null
     */
    public function getSendedDateStart()
    {
        return $this->sendedDateStart;
    }

    /**
     * Set sendedDateEnd.
     *
     * @param \DateTime|null $sendedDateEnd
     *
     * @return SMSCampaign
     */
    public function setSendedDateEnd($sendedDateEnd = null)
    {
        $this->sendedDateEnd = $sendedDateEnd;

        return $this;
    }

    /**
     * Get sendedDateEnd.
     *
     * @return \DateTime|null
     */
    public function getSendedDateEnd()
    {
        return $this->sendedDateEnd;
    }


    /**
     * Add children
     *
     * @param SMS $children
     * @return SMSCampaign
     */
    public function addChildren(SMS $children)
    {
        $this->children[] = $children;

        return $this;
    }

    /**
     * Remove children
     *
     * @param SMS $children
     */
    public function removeChildren(SMS $children)
    {
        $this->children->removeElement($children);
    }

    /**
     * Get children
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getChildren()
    {
        return $this->children;
    }

    /**
     * Count children
     *
     * @return int
     */
    public function countChildren()
    {
        return count($this->children);
    }
    /**
     * List children
     *
     * @return string
     */
    public function listChildren()
    {
        $sms_sended = array();

        if ($this->children) {
            foreach ($this->children as $sms) {
                $user = $sms->getUser();    
                $sms_sended[] = $user->getFirstname() . ' ' . $user->getLastname() . ' <' . $sms->getMobile() . '> ';    
            }
        }
        
        return implode(', ', $sms_sended);
    }

    /**
     * Count children
     *
     * @return int
     */
    public function getNbSMSSended()
    {
        $sms_sended = 0;

        if ($this->children) {
            foreach ($this->children as $sms) {
                $sms_sended += (int) $sms->getSendinblueNbSms();    
            }
        }
        
        return $sms_sended;
    }

    /**
     * Count children
     *
     * @return float
     */
    public function getCreditUsed()
    {
        $credit_used = 0;

        if ($this->children) {
            foreach ($this->children as $sms) {
                $credit_used += (float) $sms->getSendinblueCreditUsed();    
            }
        }
        
        return $credit_used / 100;
    }
}
