<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SMS
 *
 * @ORM\Table(name="sms")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\SMSRepository")
 * @ORM\HasLifecycleCallbacks
 */
class SMS
{
    const STATE_WAITING = 0;
    const STATE_SENDED = 1;
    const STATE_ERROR = -1;
    
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="SMSCampaign", inversedBy="children")
     * @ORM\JoinColumn(name="campaign_id", referencedColumnName="id")
     */
    private $campaign;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="id")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id")
     */
    private $user;

    /**
     * @var string
     *
     * @ORM\Column(name="mobile", type="string", length=13)
     */
    private $mobile;

    /**
     * @var string
     *
     * @ORM\Column(name="content", type="text")
     */
    private $content;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created", type="datetime")
     */
    private $created;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="sended_date", type="datetime", nullable=true)
     */
    private $sendedDate;

    /**
     * @var int
     *
     * @ORM\Column(name="sended", type="integer")
     */
    private $sended = self::STATE_WAITING;

    /**
     * @var string|null
     *
     * @ORM\Column(name="sendinblue_ref", type="string", length=255, nullable=true)
     */
    private $sendinblueRef;

    /**
     * @var array|null
     *
     * @ORM\Column(name="sendinblue_api_return", type="array", nullable=true)
     */
    private $sendinblueApiReturn;

    /**
     * @var int|null
     *
     * @ORM\Column(name="sendinblue_nb_sms", type="integer", nullable=true)
     */
    private $sendinblueNbSms;

    /**
     * @var float|null
     *
     * @ORM\Column(name="sendinblue_credit_used", type="float", nullable=true)
     */
    private $sendinblueCreditUsed;

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set campaign.
     *
     * @param SMSCampaign|SMSCampaignPEE $campaign
     *
     * @return SMS
     */
    public function setCampaign($campaign)
    {
        $this->campaign = $campaign;

        return $this;
    }

    /**
     * Get campaign.
     *
     * @return SMSCampaign|SMSCampaignPEE
     */
    public function getCampaign()
    {
        return $this->campaign;
    }


    /**
     * Set user.
     *
     * @param User $user
     *
     * @return SMS
     */
    public function setUser(User $user)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user.
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set mobile.
     *
     * @param string $mobile
     *
     * @return SMS
     */
    public function setMobile($mobile)
    {
        $this->mobile = $mobile;

        return $this;
    }

    /**
     * Get mobile.
     *
     * @return string
     */
    public function getMobile()
    {
        return $this->mobile;
    }

    /**
     * Set content.
     *
     * @param string $content
     *
     * @return SMS
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }

    /**
     * Get content.
     *
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Set created.
     *
     * @param \DateTime $created
     *
     * @return SMS
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedValue()
    {
        $this->created = new \DateTime();
    }

    /**
     * Get created.
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set sendedDate.
     *
     * @param \DateTime|null $sendedDate
     *
     * @return SMS
     */
    public function setSendedDate($sendedDate = null)
    {
        $this->sendedDate = $sendedDate;

        return $this;
    }

    /**
     * Get sendedDate.
     *
     * @return \DateTime|null
     */
    public function getSendedDate()
    {
        return $this->sendedDate;
    }

    /**
     * Set sended.
     *
     * @param int $sended
     *
     * @return SMS
     */
    public function setSended($sended)
    {
        $this->sended = $sended;

        return $this;
    }

    /**
     * Get sended.
     *
     * @return int
     */
    public function getSended()
    {
        return $this->sended;
    }

    /**
     * Set sendinblueRef.
     *
     * @param string|null $sendinblueRef
     *
     * @return SMS
     */
    public function setSendinblueRef($sendinblueRef = null)
    {
        $this->sendinblueRef = $sendinblueRef;

        return $this;
    }

    /**
     * Get sendinblueRef.
     *
     * @return string|null
     */
    public function getSendinblueRef()
    {
        return $this->sendinblueRef;
    }

    /**
     * Set sendinblueApiReturn.
     *
     * @param string|null $sendinblueApiReturn
     *
     * @return SMS
     */
    public function setSendinblueApiReturn($sendinblueApiReturn = null)
    {
        $this->sendinblueApiReturn = $sendinblueApiReturn;

        return $this;
    }

    /**
     * Get sendinblueApiReturn.
     *
     * @return string|null
     */
    public function getSendinblueApiReturn()
    {
        return $this->sendinblueApiReturn;
    }

    /**
     * Set sendinblueNbSms.
     *
     * @param int|null $sendinblueNbSms
     *
     * @return SMS
     */
    public function setSendinblueNbSms($sendinblueNbSms = null)
    {
        $this->sendinblueNbSms = $sendinblueNbSms;

        return $this;
    }

    /**
     * Get sendinblueNbSms.
     *
     * @return int|null
     */
    public function getSendinblueNbSms()
    {
        return $this->sendinblueNbSms;
    }

    /**
     * Set sendinblueCreditUsed.
     *
     * @param float|null $sendinblueCreditUsed
     *
     * @return SMS
     */
    public function setSendinblueCreditUsed($sendinblueCreditUsed = null)
    {
        $this->sendinblueCreditUsed = $sendinblueCreditUsed;

        return $this;
    }

    /**
     * Get sendinblueCreditUsed.
     *
     * @return float|null
     */
    public function getSendinblueCreditUsed()
    {
        return $this->sendinblueCreditUsed;
    }
}
