<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use AppBundle\Entity\MerHistoryITDLC;
use Symfony\Component\Validator\Context\ExecutionContextInterface;

/**
 * MerITDLC
 *
 * @ORM\Table(name="mer_ITDLC")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\MerITDLCRepository")
 * @ORM\HasLifecycleCallbacks
 */
class MerITDLC
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var OperationITDLC $ope
     *
     * @ORM\ManyToOne(targetEntity="OperationITDLC", inversedBy="merITDLC")
     * @ORM\JoinColumn(name="ope_id", referencedColumnName="id", nullable=true)
     */
    private $ope;

    /**
     * @var User $inge
     *
     * @ORM\ManyToOne(targetEntity="User", inversedBy="merITDLC")
     * @ORM\JoinColumn(name="inge_id", referencedColumnName="id", nullable=true)
     */
    private $inge;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="first_date", type="datetime", nullable=true)
     */
    private $firstDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="first_date_start_time", type="time", nullable=true)
     */
    private $firstDateStartTime;

    /**
     * @var \DateTime
     * @ORM\Column(name="first_date_end_time", type="time", nullable=true)
     */
    private $firstDateEndTime;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="second_date", type="datetime", nullable=true)
     */
    private $secondDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="second_date_start_time", type="time", nullable=true)
     */
    private $secondDateStartTime;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="second_date_end_time", type="time", nullable=true)
     */
    private $secondDateEndTime;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="third_date", type="datetime", nullable=true)
     */
    private $thirdDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="third_date_start_time", type="time", nullable=true)
     */
    private $thirdDateStartTime;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="third_date_end_time", type="time", nullable=true)
     */
    private $thirdDateEndTime;

    /**
     * @var string|null
     *
     * @ORM\Column(name="answer", type="string", nullable=true)
     */
    private $answer;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="answer_date", type="datetime", nullable=true)
     */
    private $answerDate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created_at", type="datetime")
     */
    private $createdAt;


    /**
     * @var string|null
     *
     * @ORM\Column(name="comment", type="text", nullable=true)
     */
    private $comment;

    /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="MerHistoryITDLC", mappedBy="merITDLC", fetch="EXTRA_LAZY", cascade={"persist"})
     * @ORM\OrderBy({"createdAt" = "ASC"})
     */
    private $histories;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="reminder_at", type="datetime", nullable=true)
     */
    private $reminderAt;


    /**
     * @ORM\PrePersist
     */
    public function setCreatedAtValue()
    {
        $this->createdAt = new \DateTime();
    }

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->histories = new ArrayCollection();
        $this->operationHistories = new ArrayCollection();
    }


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set ope
     *
     * @param OperationITDLC $ope
     * @return MerITDLC
     */
    public function setOpe(OperationITDLC $ope)
    {
        $this->ope = $ope;

        return $this;
    }



    /**
     * Get ope.
     *
     * @return OperationITDLC
     */
    public function getOpe()
    {
        return $this->ope;
    }

    /**
     * Set inge
     *
     * @param User $inge
     * @return MerITDLC
     */
    public function setInge(User $inge)
    {
        $this->inge = $inge;

        return $this;
    }

    /**
     * Get inge
     *
     * @return User
     */
    public function getInge()
    {
        return $this->inge;
    }

    /**
     * Set firstDate.
     *
     * @param \DateTime $firstDate
     *
     * @return MerITDLC
     */
    public function setFirstDate($firstDate)
    {
        $this->firstDate = $firstDate;

        return $this;
    }

    /**
     * Get firstDate.
     *
     * @return \DateTime
     */
    public function getFirstDate()
    {
        return $this->firstDate;
    }

    /**
     * Set firstDateStartTime
     *
     * @param \DateTime|null $startTime
     *
     * @return MerITDLC
     */
    public function setFirstDateStartTime($startTime = null)
    {
        $this->firstDateStartTime = $startTime;

        return $this;
    }

    /**
     * Get firstDateStartTime
     *
     * @return \DateTime|null
     */
    public function getFirstDateStartTime()
    {
        return $this->firstDateStartTime;
    }

    /**
     * Set firstDateEndTime
     *
     * @param \DateTime|null $endTime
     *
     * @return MerITDLC
     */
    public function setFirstDateEndTime($endTime = null)
    {
        $this->firstDateEndTime = $endTime;

        return $this;
    }

    /**
     * Get firstDateEndTime
     *
     * @return \DateTime|null
     */
    public function getFirstDateEndTime()
    {
        return $this->firstDateEndTime;
    }

    /**
     * Set secondDate.
     *
     * @param \DateTime|null $secondDate
     *
     * @return MerITDLC
     */
    public function setSecondDate($secondDate = null)
    {
        $this->secondDate = $secondDate;

        return $this;
    }

    /**
     * Get secondDate.
     *
     * @return \DateTime|null
     */
    public function getSecondDate()
    {
        return $this->secondDate;
    }

    /**
     * Set secondDateStartTime
     *
     * @param \DateTime|null $startTime
     *
     * @return MerITDLC
     */
    public function setSecondDateStartTime($startTime = null)
    {
        $this->secondDateStartTime = $startTime;

        return $this;
    }

    /**
     * Get secondDateStartTime
     *
     * @return \DateTime|null
     */
    public function getSecondDateStartTime()
    {
        return $this->secondDateStartTime;
    }

    /**
     * Get secondDateEndTime
     * @return \DateTime|null
     */
    public function getSecondDateEndTime()
    {
        return $this->secondDateEndTime;
    }

    /**
     * Set secondDateEndTime
     * @param \DateTime|null $secondDateEndTime
     */
    public function setSecondDateEndTime($secondDateEndTime = null)
    {
        $this->secondDateEndTime = $secondDateEndTime;
    }

    /**
     * Set thirdDate.
     *
     * @param \DateTime|null $thirdDate
     *
     * @return MerITDLC
     */
    public function setThirdDate($thirdDate = null)
    {
        $this->thirdDate = $thirdDate;

        return $this;
    }

    /**
     * Get thirdDate.
     *
     * @return \DateTime|null
     */
    public function getThirdDate()
    {
        return $this->thirdDate;
    }

    /**
     * Set thirdDateStartTime
     *
     * @param \DateTime|null $startTime
     *
     * @return MerITDLC
     */
    public function setThirdDateStartTime($startTime = null)
    {
        $this->thirdDateStartTime = $startTime;

        return $this;
    }

    /**
     * Get secondDateStartTime
     *
     * @return \DateTime|null
     */
    public function getThirdDateStartTime()
    {
        return $this->thirdDateStartTime;
    }

    /**
     * Get thirdDateStartTime
     * @return \DateTime|null
     */
    public function getThirdDateEndTime()
    {
        return $this->thirdDateEndTime;
    }

    /**
     * Get thirdDateEndTime
     * @param \DateTime|null $endTime
     */
    public function setThirdDateEndTime($endTime = null)
    {
        $this->thirdDateEndTime = $endTime;
    }

    /**
     * Set answer.
     *
     * @param string $answer
     *
     * @return MerITDLC
     */
    public function setAnswer($answer = null)
    {
        $this->answer = $answer;

        return $this;
    }

    /**
     * Get answer.
     *
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->answer;
    }

    /**
     * Set answerDate.
     *
     * @param \DateTime|null $answerDate
     *
     * @return MerITDLC
     */
    public function setAnswerDate($answerDate = null)
    {
        $this->answerDate = $answerDate;

        return $this;
    }

    /**
     * Get answerDate.
     *
     * @return \DateTime|null
     */
    public function getAnswerDate()
    {
        return $this->answerDate;
    }

    /**
     * Set createdAt.
     *
     * @param \DateTime $createdAt
     *
     * @return MerITDLC
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt.
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }


    /**
     * Get all the dates of the request
     */
    public function getAllDates()
    {

        $dates = array();

        if (!empty($this->firstDate)) {
            $date = array();
            $date['day'] = $this->firstDate;
            if (!empty($this->firstDateStartTime)) {
                $date['hours'] = array(
                    'startTime' => $this->firstDateStartTime,
                    'endTime' => $this->firstDateEndTime
                );
            }

            $dates[] = $date;
        }

        if (!empty($this->secondDate)) {
            $date = array();
            $date['day'] = $this->secondDate;
            if (!empty($this->secondDateStartTime)) {
                $date['hours'] = array(
                    'startTime' => $this->secondDateStartTime,
                    'endTime' => $this->secondDateEndTime
                );
            }

            $dates[] = $date;
        }

        if (!empty($this->thirdDate)) {
            $date = array();
            $date['day'] = $this->thirdDate;
            if (!empty($this->thirdDateStartTime)) {
                $date['hours'] = array(
                    'startTime' => $this->thirdDateStartTime,
                    'endTime' => $this->thirdDateEndTime
                );
            }

            $dates[] = $date;
        }


        return $dates;
    }


    /**
     * Add history
     *
     * @param MerHistoryITDLC $merHistoryITDLC
     *
     * @return User
     */
    public function addHistory(MerHistoryITDLC $merHistoryITDLC)
    {
        $this->histories[] = $merHistoryITDLC;
        $merHistoryITDLC->setMerITDLC($this);

        return $this;
    }

    /**
     * GET history
     *
     * @return ArrayCollection
     */
    public function getHistories()
    {
        return $this->histories;
    }

    /**
     * GET Last history
     *
     * @return merHistoryITDLC
     */
    public function getLastHistory()
    {
        return $this->histories->last();
    }

    /**
     * @param ExecutionContextInterface $context
     * @param $payload
     */
    public function validateTimes(ExecutionContextInterface $context, $payload)
    {


        // Date 1
        if ($this->getFirstDateStartTime() < $this->getFirstDateEndTime()) {
            $context->buildViolation("L'heure de fin doit être supérieur à l'heure de début")
                ->atPath('firstDateEndTime')
                ->addViolation();
        }

        // Date 2
        if ($this->getSecondDateStartTime() < $this->getSecondDateEndTime()) {
            $context->buildViolation("L'heure de fin doit être supérieur à l'heure de début")
                ->atPath('secondDateEndTime')
                ->addViolation();
        }

        // Date 1
        if ($this->getThirdDateStartTime() < $this->getThirdDateEndTime()) {
            $context->buildViolation("L'heure de fin doit être supérieur à l'heure de début")
                ->atPath('thirdDateEndTime')
                ->addViolation();
        }
    }


    /**
     * Set Comment
     *
     * @param string|null $comment
     * @return MerITDLC
     */
    public function setComment($comment = null)
    {
        $this->comment = $comment;

        return $this;
    }

    /**
     * Get comment.
     *
     * @return string|null comment
     */
    public function getComment()
    {
        return $this->comment;
    }


    /**
     * Set reminder at
     *
     * @return MerITDLC
     */
    public function setReminderAt()
    {
        $this->reminderAt = new \DateTime();

        return $this;
    }

    /**
     * Get reminder at
     *
     * @return \DateTime
     */
    public function getReminderAt()
    {
        return $this->reminderAt;
    }
}
