<?php

namespace AppBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\File;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

/**
 * Establishment
 * @author Bastien Gatellier <contact@bgatellier.fr>
 *
 * @ORM\Table(name="establishment")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\EstablishmentRepository")
 * @ORM\InheritanceType("SINGLE_TABLE")
 * @ORM\DiscriminatorColumn(name="type", type="string")
 * @ORM\DiscriminatorMap({"company" = "Company", "partner" = "Partner"})
 * @ORM\HasLifecycleCallbacks
 * @Vich\Uploadable
 */
abstract class Establishment
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, unique=false, nullable=true)
     */
    protected $name;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    protected $description;

    /**
     * @var string
     *
     * @ORM\Column(name="website", type="string", length=255, nullable=true)
     */
    protected $website;

    /**
     * @var integer $position
     *
     * @ORM\Column(name="position", type="integer", nullable=true)
     */
    private $position = 0;

    /**
     * @var string
     *
     * @ORM\Column(name="logoPath", type="string", length=255, nullable=true)
     */
    protected $logoPath;

    /**
     * @var int
     *
     * @ORM\Column(name="logoSize", type="integer", nullable=true)
     */
    protected $logoSize;

    /**
     * @var File
     * 
     * @Vich\UploadableField(mapping="establishment_logo", fileNameProperty="logoPath", size="logoSize")
     */
    protected $logoFile;

    /**
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\User", mappedBy="establishment", fetch="EXTRA_LAZY")
     */
    protected $users;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     *
     * @var \DateTime
     */
    protected $createdAt;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     *
     * @var \DateTime
     */
    protected $updatedAt;

    /**
     * @var string
     *
     * @ORM\Column(name="partner_group", type="string", length=255, nullable=true)
     */
    protected $partner_group;


    public function __construct()
    {
        $this->users = new ArrayCollection();
    }

    public function __toString()
    {
        return is_null($this->getName()) ? "" : $this->getName();
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Establishment
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Establishment
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set website
     *
     * @param string $website
     *
     * @return Establishment
     */
    public function setWebsite($website)
    {
        $this->website = $website;

        return $this;
    }

    /**
     * Get website
     *
     * @return string
     */
    public function getWebsite()
    {
        return $this->website;
    }

    /**
     * Set logoFile
     *
     * @param File|\Symfony\Component\HttpFoundation\File\UploadedFile $logoFile
     *
     * @return Establishment
     */
    public function setLogoFile(File $logoFile = null)
    {
        $this->logoFile = $logoFile;

        if ($logoFile) {
            // It is required that at least one field changes if you are using doctrine
            // otherwise the event listeners won't be called and the file is lost
            $this->updatedAt = new \DateTimeImmutable();
        }

        return $this;
    }

    /**
     * Get logoFile
     *
     * @return File|null
     */
    public function getLogoFile()
    {
        return $this->logoFile;
    }

    /**
     * Set logoPath
     *
     * @param string $logoPath
     *
     * @return Establishment
     */
    public function setLogoPath($logoPath)
    {
        $this->logoPath = $logoPath;

        return $this;
    }

    /**
     * Get logoPath
     *
     * @return string
     */
    public function getLogoPath()
    {
        return $this->logoPath;
    }

    /**
     * Set logoSize
     *
     * @param int $logoSize
     *
     * @return Establishment
     */
    public function setLogoSize($logoSize)
    {
        $this->logoSize = $logoSize;

        return $this;
    }

    /**
     * Get logoSize
     *
     * @return int
     */
    public function getLogoSize()
    {
        return $this->logoSize;
    }

    /**
     * Add user
     *
     * @param User $user
     * 
     * @return Establishment
     */
    public function addUser(User $user)
    {
        $this->users[] = $user;

        return $this;
    }

    /**
     * Remove user
     *
     * @param User $user
     */
    public function removeUser(User $user)
    {
        $this->users->removeElement($user);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUsers()
    {
        return $this->users;
    }

    /**
     * Set createdAt
     *
     * @param \DateTime $createdAt
     *
     * @return Establishment
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * Set updatedAt
     *
     * @param \DateTime $updatedAt
     *
     * @return Establishment
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * Get updatedAt
     *
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * Set position
     *
     * @param int $position
     * 
     * @return Establishment
     */
    public function setPosition($position)
    {
        $this->position = $position;

        return $this;
    }

    /**
     * Get position
     *
     * @return integer
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     *
     * @ORM\PrePersist
     * @ORM\PreUpdate
     */
    public function updatedTimestamps()
    {
        $this->setUpdatedAt(new \DateTimeImmutable());

        if (!$this->getCreatedAt()) {
            $this->setCreatedAt(new \DateTimeImmutable());
        }
    }

    /**
     * Indicates if an establishment can be deleted.
     * This method takes advantages of the fetch="EXTRA_LAZY" Doctrine annotation, using only count() on ArrayCollection.
     * @see http://docs.doctrine-project.org/projects/doctrine-orm/en/latest/tutorials/extra-lazy-associations.html Extra Lazy Associations
     * @return boolean 
     */
    public function isDeletable()
    {
        return 0 === count($this->getUsers());
    }

    /**
     * Set partner_group
     *
     * @param string $partner_group
     *
     * @return Establishment
     */
    public function setPartnerGroup($partner_group)
    {
        $this->partner_group = $napartner_groupme;

        return $this;
    }

    /**
     * Get partner_group
     *
     * @return string
     */
    public function getPartnerGroup()
    {
        return $this->partner_group;
    }
}
