<?php

namespace AppBundle\Controller\Admin;

use AppBundle\Entity\SettingsOperationITDLC;
use AppBundle\Form\Type\ITDLC\SettingsOperationITDLCType;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Translation\TranslatorInterface;

/**
 * @Route("/settings")
 */
class SettingsController extends Controller
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * @var TranslatorInterface
     */
    private $translator;
    
    public function __construct(EntityManagerInterface $em, TranslatorInterface $translator)
    {
        $this->em = $em;
        $this->translator = $translator;
    }

    /**
     * @Route(
     *      "/",
     *      name = "admin_settings"
     * )
     * @Method("GET")
     *
     * @param Request $request
     * @param int $page
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function indexAction(Request $request, int $page = 1)
    {
        return $this->redirectToRoute('company_index', [
            'request' => $request,
            'page' => $page,
        ]);
    }

    /**
     * @Route(
     *      "/operation-itdlc",
     *      name = "settings_operationitdlc"
     * )
     * @Method({"GET", "POST"})
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\RedirectResponse|\Symfony\Component\HttpFoundation\Response
     */
    public function operationItdlcAction(Request $request)
    {
        // Grab the settings from the database. Create empty settings if nothing has been saved yet.
        if (null ===$settingsOperationItdlc = $this->em->getRepository(SettingsOperationITDLC::class)->findOneBy([])) {
            $settingsOperationItdlc = new SettingsOperationITDLC;
        }

        $form = $this->createForm(SettingsOperationITDLCType::class, $settingsOperationItdlc);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->em->persist($settingsOperationItdlc);
            $this->em->flush();

            $this->addFlash('success', $this->translator->trans('notice.settings.operationITDLC.updated', [], 'notice'));

            return $this->redirectToRoute('settings_operationitdlc');
        }

        return $this->render('Admin/Settings/ope/itdlc/index.html.twig', [
            'form' => $form->createView()
        ]);
    }
}
