<?php declare(strict_types=1);

namespace Application\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\DBAL\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20190116155508 extends AbstractMigration
{
    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('CREATE SEQUENCE Interest_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE TABLE Interest (id INT NOT NULL, user_id INT NOT NULL, operationitdlc_id INT DEFAULT NULL, operationpee_id INT DEFAULT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE INDEX IDX_95487831A76ED395 ON Interest (user_id)');
        $this->addSql('CREATE INDEX IDX_954878311A1C62BE ON Interest (operationitdlc_id)');
        $this->addSql('CREATE INDEX IDX_9548783173D5705F ON Interest (operationpee_id)');
        $this->addSql('ALTER TABLE Interest ADD CONSTRAINT FK_95487831A76ED395 FOREIGN KEY (user_id) REFERENCES fos_user (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE Interest ADD CONSTRAINT FK_954878311A1C62BE FOREIGN KEY (operationitdlc_id) REFERENCES OperationITDLC (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE Interest ADD CONSTRAINT FK_9548783173D5705F FOREIGN KEY (operationpee_id) REFERENCES OperationPEE (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('DROP SEQUENCE Interest_id_seq CASCADE');
        $this->addSql('DROP TABLE Interest');
    }
}
