<?php

namespace Application\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
class Version20171101153814 extends AbstractMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('CREATE SEQUENCE document_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE SEQUENCE settings_id_seq INCREMENT BY 1 MINVALUE 1 START 1');
        $this->addSql('CREATE TABLE document (id INT NOT NULL, title VARCHAR(255) NOT NULL, file_mime_type VARCHAR(255) NOT NULL, file_path VARCHAR(255) NOT NULL, file_size INT NOT NULL, created_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, updated_at TIMESTAMP(0) WITHOUT TIME ZONE NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE settings (id INT NOT NULL, type VARCHAR(255) NOT NULL, PRIMARY KEY(id))');
        $this->addSql('CREATE TABLE settings_operationitdlc_teacher_documents (settings_operationitdlc_id INT NOT NULL, document_id INT NOT NULL, PRIMARY KEY(settings_operationitdlc_id, document_id))');
        $this->addSql('CREATE INDEX IDX_DF86DC7FD993FA75 ON settings_operationitdlc_teacher_documents (settings_operationitdlc_id)');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_DF86DC7FC33F7837 ON settings_operationitdlc_teacher_documents (document_id)');
        $this->addSql('CREATE TABLE settings_operationitdlc_engineer_documents (settings_operationitdlc_id INT NOT NULL, document_id INT NOT NULL, PRIMARY KEY(settings_operationitdlc_id, document_id))');
        $this->addSql('CREATE INDEX IDX_4127E580D993FA75 ON settings_operationitdlc_engineer_documents (settings_operationitdlc_id)');
        $this->addSql('CREATE UNIQUE INDEX UNIQ_4127E580C33F7837 ON settings_operationitdlc_engineer_documents (document_id)');
        $this->addSql('ALTER TABLE settings_operationitdlc_teacher_documents ADD CONSTRAINT FK_DF86DC7FD993FA75 FOREIGN KEY (settings_operationitdlc_id) REFERENCES settings (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE settings_operationitdlc_teacher_documents ADD CONSTRAINT FK_DF86DC7FC33F7837 FOREIGN KEY (document_id) REFERENCES document (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE settings_operationitdlc_engineer_documents ADD CONSTRAINT FK_4127E580D993FA75 FOREIGN KEY (settings_operationitdlc_id) REFERENCES settings (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
        $this->addSql('ALTER TABLE settings_operationitdlc_engineer_documents ADD CONSTRAINT FK_4127E580C33F7837 FOREIGN KEY (document_id) REFERENCES document (id) NOT DEFERRABLE INITIALLY IMMEDIATE');
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'postgresql', 'Migration can only be executed safely on \'postgresql\'.');

        $this->addSql('ALTER TABLE settings_operationitdlc_teacher_documents DROP CONSTRAINT FK_DF86DC7FC33F7837');
        $this->addSql('ALTER TABLE settings_operationitdlc_engineer_documents DROP CONSTRAINT FK_4127E580C33F7837');
        $this->addSql('ALTER TABLE settings_operationitdlc_teacher_documents DROP CONSTRAINT FK_DF86DC7FD993FA75');
        $this->addSql('ALTER TABLE settings_operationitdlc_engineer_documents DROP CONSTRAINT FK_4127E580D993FA75');
        $this->addSql('DROP SEQUENCE document_id_seq CASCADE');
        $this->addSql('DROP SEQUENCE settings_id_seq CASCADE');
        $this->addSql('DROP TABLE document');
        $this->addSql('DROP TABLE settings');
        $this->addSql('DROP TABLE settings_operationitdlc_teacher_documents');
        $this->addSql('DROP TABLE settings_operationitdlc_engineer_documents');
    }
}
