<?php

namespace AppBundle\Repository;

use AppBundle\Entity\OperationITDLC;
use AppBundle\Entity\User;
use AppBundle\Enum\OperationITDLCState;
use AppBundle\Enum\OperationITDLCType;
use AppBundle\Enum\OperationPEEState;
use AppBundle\Enum\PreferenceKm;
use AppBundle\Enum\UserType;

/**
 * MerITDLCRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class MerITDLCRepository extends \Doctrine\ORM\EntityRepository
{
    public function getMerWithoutAnswer()
    {

        /**
         *
         */
        $qb = $this->createQueryBuilder('m')
            ->select('m, o, p')
            ->join('m.ope', 'o')
            ->join('o.prof', 'p')
            ->join('o.inge', 'i')
            ->where('m.createdAt <= :j5')
            ->andWhere('m.answer is null')
            ->andWhere('m.reminderAt is null')
        ;

        $j5 = date('Y-m-d', strtotime('-5days'));
        $qb->setParameter("j5", $j5);

        return $qb->getQuery()->getResult();
    }

    /**
     * @return mixed
     */
    public function getMerWithoutAnswerAfterReminders()
    {
        $qb = $this->createQueryBuilder('m')
            ->select('m, o, p')
            ->join('m.ope', 'o')
            ->join('o.prof', 'p')
            ->join('o.inge', 'i')
            ->where('m.createdAt <= :j10')
            ->andWhere('m.answer is null')
            ->andWhere('m.reminderAt is not null')
        ;

        $j10 = date('Y-m-d 23:59:59', strtotime('-10days'));
        $qb->setParameter("j10", $j10);

        return $qb->getQuery()->getResult();
    }
}
