<?php

namespace AppBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query;

/**
 * MenuMediaRepository
 */
class MenuMediaRepository extends EntityRepository
{
    /**
     * Retourne l'ensemble des MenuMedia qui correspondent aux Ids des menus et des médias donnés.
     *
     * @param array $menusIds Liste des identifiants de menu
     * @param int $mediaId Identifiant du média
     * @param int $hydratation Doctrine hydratation mode
     *
     * @return array
     */
    public function findAllByMenusAndMedia(array $menusIds, int $mediaId, int $hydratation = Query::HYDRATE_OBJECT): array
    {
        $qbmm = $this->getEntityManager()->createQueryBuilder();
        $qbmm
            ->select('mm')
            ->from('AppBundle:MenuMedia', 'mm')
            ->leftJoin('mm.menu', 'menu')
            ->leftJoin('mm.media', 'media')
            ->where($qbmm->expr()->in('menu.id', ':menu_ids'))
            ->andWhere('media.id = :media_id')
            ->setParameters(array(
                'menu_ids' => $menusIds,
                'media_id' => $mediaId,
            ));

        return $qbmm->getQuery()->getResult($hydratation);
    }
}
