<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\Company;
use AppBundle\Entity\OperationPEECategory;
use AppBundle\Enum\ClassroomLevel;
use AppBundle\Enum\EstablishmentType;
use AppBundle\Enum\EstablishmentEducation;
use AppBundle\Enum\UserHonorific;
use AppBundle\Enum\UserJobEngineer;
use AppBundle\Enum\UserJobEngineerCategory;
use AppBundle\Enum\UserJobTeacher;
use AppBundle\Enum\UserJobTeacherCategory;
use AppBundle\Enum\UserRep;
use AppBundle\Enum\UserSchoolGrade;
use AppBundle\Enum\UserType;
use AppBundle\Helper\UserHelper;
use AppBundle\Repository\CompanyRepository;
use AppBundle\Repository\UserRepository;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query;
use FOS\UserBundle\Form\Type\ProfileFormType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\BirthdayType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class UserFormType extends AbstractType
{
    /**
     * Constructor
     * 
     * @param UserRepository $ur
     * @param ConstTranslator $utils
     */
    public function __construct(UserRepository $ur, ConstTranslator $utils)
    {
        $this->userHonorifics = $utils->trans(UserHonorific::class);

        $this->ur = $ur;
        $this->utils = $utils;
    }
    
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->remove('username')
            ->remove('current_password')
        ;

        if (UserType::TEACHER === $builder->getData()->getType()) {
            $this->academies = UserHelper::getAcademyList();
            $this->classroomLevels = $this->utils->trans(ClassroomLevel::class);
            $this->jobsCategories = $this->utils->trans(UserJobTeacherCategory::class);
            $this->jobs = $this->utils->trans(UserJobTeacher::class);

            $this->repLevels = $this->utils->trans(UserRep::class);
            $this->establishmentType = $this->utils->trans(EstablishmentType::class);
            $this->establishmentEducation = $this->utils->trans(EstablishmentEducation::class);

            $this->shoeSizeOptions = UserHelper::getShoeSizeOptions();
        } else {
            $this->jobsCategories = $this->utils->trans(UserJobEngineerCategory::class);
            $this->jobs = $this->utils->trans(UserJobEngineer::class);
            $this->classroomLevels = $this->utils->trans(ClassroomLevel::class);
            $this->formations = $this->utils->trans(UserSchoolGrade::class);

            $this->transportTypeOptions = UserHelper::getTransportTypeOptions();
            $this->transportDistanceOptions = UserHelper::getTransportDistanceOptions();
            $this->transportTimeOptions = UserHelper::getTransportTimeOptions();
            $this->nbContributionsOptions = UserHelper::getNbContributionsOptions();
        }


        $this->buildUserForm($builder, $options);

        if (UserType::TEACHER === $builder->getData()->getType()) {
            $this->buildEstablishmentForm($builder, $options);
        } else {
            $this->buildCompanyForm($builder, $options);
        }


        $builder
            ->add('is_active', CheckboxType::class, [
                'label' => 'form.is_active.label',
                'required' => false,
            ])
            // ->add('is_available', CheckboxType::class, [
            //     'label' => 'form.profile.is_available.label',
            //     'required' => false,
            // ])
            ->add('note', TextareaType::class, [
                'label' => 'form.notes.label',
                'required' => false,
            ])
        ;
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildUserForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            // ->add('username', HiddenType::class, array(
            //     //'required' => false
            // ))
            // ->add('honorific', ChoiceType::class, array(
            //     'choices' => array_flip($this->userHonorifics),
            //     //'expanded' => true,
            //     'label' => 'form.profile.honorific.label',
            //     'required' => false
            // ))
            // ->add('firstname', TextType::class, array(
            //     'label' => 'form.profile.firstname.label',
            //     'required' => false
            // ))
            // ->add('lastname', TextType::class, array(
            //     'label' => 'form.profile.lastname.label',
            //     'required' => false
            // ))
            // ->add('birthday', BirthdayType::class, array(
            //     'format' => 'ddMMMMyyyy',
            //     'label' => 'form.profile.birthday.label',
            //     'required' => false,
            // ))
            ->add('phone', TextType::class, array(
                'label' => 'form.profile.phone.label',
                'required' => false,
            ))
            ->add('mobile', TextType::class, array(
                //'help' => 'form.profile.mobile.help', 
                'label' => 'form.profile.mobile.label',
                'required' => false,
            ))
            // ->add('photoFile', FileType::class, array(
            //     'attr' => array('class' => 'image_input'),
            //     'help' => 'form.profile.photo.help',
            //     'image_path' => 'webPhoto',
            //     'image_filter' => '48Lx48H',
            //     'label' => 'form.profile.photo.label',
            //     'required' => false,
            // ))
            // ->add('newsletter', CheckboxType::class, array(
            //     'label' => 'form.profile.newsletter.label',
            //     'required' => false,
            // ))
        ;

        if (UserType::TEACHER === $builder->getData()->getType()) {
            // $builder
            //     ->add('categoryJob', ChoiceType::class, array(
            //         'choices' => array_flip($this->jobsCategories),
            //         'label' => 'form.profile.teacher.jobcategory.label',
            //         'required' => false,
            //     ))
            //     ->add('job', ChoiceType::class, array(
            //         'choices' => array_flip($this->jobs),
            //         'label' => 'form.profile.teacher.job.label',
            //         'required' => false,
            //         'attr' => array(
            //             'class' => 'relationship-with-other-field'
            //         ),
            //     ))
            //     ->add('jobOther', TextType::class, array(
            //         'label' => 'form.profile.teacher.jobother.label',
            //         'required' => false,
            //     ))
            //     ->add('classroom', ChoiceType::class, array(
            //         'choices' => array_flip($this->classroomLevels),
            //         'expanded' => true,
            //         'label' => 'form.profile.teacher.classroom.label',
            //         'multiple' => true,
            //         'required' => false,
            //     ))
            //     ->add('professionalDiscover', ChoiceType::class, array(
            //         'label' => 'form.profile.teacher.professionalDiscover.label',
            //         'choices' => array(
            //             "Oui" => true,
            //             "Non" => false
            //         ),
            //         'expanded' => true,
            //         'required' => false,
            //     ))
            //     ->add('shoeSize', ChoiceType::class, array(
            //         'choices' => $this->shoeSizeOptions,
            //         'label' => 'form.profile.shoeSize.label',
            //         'required' => false,
            //     ))
            // ;
        } else {
            $builder
            //     ->add('personalAddress', TextType::class, array(
            //         'label' => 'form.profile.personaladdress.address.label',
            //         'required' => false,
            // )   )
                ->add('personalZipcode', TextType::class, array(
                    'label' => 'form.profile.personaladdress.zipcode.label',
                    'required' => false,
                ))
                ->add('personalCity', TextType::class, array(
                    'label' => 'form.profile.personaladdress.city.label',
                    'required' => false,
                ))
                ->add('personalLatitude', TextType::class, array(
                    'label' => 'form.profile.personaladdress.latitude.label',
                    'required' => false
                ))
                ->add('personalLongitude', TextType::class, array(
                    'label' => 'form.profile.personaladdress.longitude.label',
                    'required' => false
                ))
            //     ->add('categoryJob', ChoiceType::class, [
            //         'choices' => array_flip($this->jobsCategories),
            //         'label' => 'form.profile.engineer.jobcategory.label',
            //         'required' => false,
            //     ])
            //     ->add('job', ChoiceType::class, array(
            //         'choices' => array_flip($this->jobs),
            //         'label' => 'form.profile.engineer.job.label',
            //         'required' => false,
            //         // 'attr' => array(
            //         //     'class' => 'relationship-with-other-field'
            //         // ),
            //     ))
            //     ->add('jobOther', TextType::class, [
            //         'label' => 'form.profile.engineer.jobother.label',
            //         'required' => false,
            //     ])
            //     ->add('formation', ChoiceType::class, [
            //         'choices' => array_flip($this->formations),
            //         'label' => 'form.profile.engineer.formation.label',
            //         'required' => false,
            //     ])
            //     ->add('formationType', TextType::class, [
            //         'label' => 'form.profile.engineer.formationType.label',
            //         'required' => false,
            //     ])
            //     ->add('aboutMe', TextareaType::class, [
            //         'label' => 'form.profile.engineer.aboutme.label',
            //         'required' => false,
            //     ])
            //     // ->add('briefing', TextareaType::class, [
            //     //     'label' => 'Thèmes et objectifs envisagés de la future intervention',
            //     //     'required' => false,
            //     // ])
            //     ->add('publictransport', ChoiceType::class, [
            //         'choices' => array_flip($this->transportTypeOptions),
            //         'label' => 'form.profile.engineer.publictransport.label',
            //         'required' => false,
            //     ])
            //     ->add('transportkm', ChoiceType::class, [
            //         'choices' => array_flip($this->transportDistanceOptions),
            //         'label' => 'form.profile.engineer.transportkm.label',
            //         'required' => false,
            //     ])
            //     ->add('transporttime', ChoiceType::class, [
            //         'choices' => array_flip($this->transportTimeOptions),
            //         'label' => 'form.profile.engineer.transporttime.label',
            //         'required' => false,
            //     ])
            //     ->add('classroom', ChoiceType::class, [
            //         'label' => 'form.profile.engineer.classroom.label',
            //         'choices' => array_flip($this->classroomLevels),
            //         'multiple' => true,
            //         'expanded' => true,
            //         'required' => false,
            //     ])
            //     ->add('nbcontribution', ChoiceType::class, [
            //         'choices' => array_flip($this->nbContributionsOptions),
            //         'label' => 'form.profile.engineer.nbcontribution.label',
            //         'required' => false,
            //     ])
            //     ->add('availabilities', CollectionType::class, [
            //         'label' => 'form.profile.availabilities.label',
            //         'entry_type' => ChoiceType::class,
            //         'entry_options' => array(
            //             'label' => false,
            //             'choices' => array(
            //                 'word.everytime.label' => '',
            //                 'word.days.label' => array_flip(array(
            //                     'monday' => 'word.days.monday.label',
            //                     'tuesday' => 'word.days.tuesday.label',
            //                     'wednesday' => 'word.days.wednesday.label',
            //                     'thursday' => 'word.days.thursday.label',
            //                     'friday' => 'word.days.friday.label',
            //                     'saturday' => 'word.days.saturday.label',
            //                     'sunday' => 'word.days.sunday.label',
            //                 )),
            //                 'word.months.label' => array_flip(array(
            //                     'january' => 'word.months.january.label',
            //                     'february' => 'word.months.february.label',
            //                     'march' => 'word.months.march.label',
            //                     'april' => 'word.months.april.label',
            //                     'may' => 'word.months.may.label',
            //                     'june' => 'word.months.june.label',
            //                     'july' => 'word.months.july.label',
            //                     'august' => 'word.months.august.label',
            //                     'september' => 'word.months.september.label',
            //                     'october' => 'word.months.october.label',
            //                     'november' => 'word.months.november.label',
            //                     'december' => 'word.months.december.label',
            //                 )),
            //             ),
            //             'translation_domain' => 'form',
            //             'choice_translation_domain' => 'word',
            //         ),
            //         'allow_add' => true,
            //         'allow_delete' => true,
            //         'by_reference' => false,
            //         'label_add' => 'form.collection.btn.availabilities.add',
            //         'label_delete' => 'form.collection.btn.availabilities.delete',
            //         'error_bubbling' => false,
            //         'required' => false,
            //     ])
            ;
        }
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildEstablishmentForm(FormBuilderInterface $builder, array $options)
    {        
        $builder
            // ->add('establishmentType', ChoiceType::class, array(
            //     'choices' => array_flip($this->establishmentType),
            //     'label' => 'form.profile.teacher.establishment.type.label',
            //     'required' => false,
            // ))
            // ->add('establishmentEducation', ChoiceType::class, array(
            //     'choices' => array_flip($this->establishmentEducation),
            //     'label' => 'form.profile.teacher.establishment.education.label',
            //     'required' => false,
            // ))
            ->add('establishmentName', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.name.label',
                'required' => false,
            ))
            ->add('establishmentAddress', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.address.address.label',
                'required' => false,
            ))
            ->add('establishmentZipcode', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.address.zipcode.label',
                'required' => false,
            ))
            ->add('establishmentCity', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.address.city.label', 
                'required' => false,
            ))
            // ->add('academy', ChoiceType::class, array(
            //     'choices' => $this->academies,
            //     'label' => 'form.profile.teacher.establishment.academy.label',
            //     'placeholder' => 'form.profile.teacher.establishment.academy.placeholder',
            //     'required' => false,
            // ))
            // ->add('rep', ChoiceType::class, array(
            //     'choices' => array_flip($this->repLevels),
            //     'expanded' => true,
            //     'label' => 'form.profile.teacher.establishment.rep.label',
            //     'required' => false,
            // ))
            // ->add('establishmentEmail', EmailType::class, array(
            //     'label' => 'form.profile.teacher.establishment.email.label',
            //     'required' => false,
            // ))
            // ->add('bossEmail', EmailType::class, array(
            //     'label' => 'form.profile.teacher.establishment.bossEmail.label',
            //     'help' => 'form.profile.teacher.establishment.bossEmail.help',
            //     'required' => false,
            // ))
            ->add('latitude', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.address.latitude.label',
                'required' => false
            ))
            ->add('longitude', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.address.longitude.label',
                'required' => false
            ))
        ;
    }

    /**
     *
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildCompanyForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('establishment', EntityType::class, [
                'class' => Company::class,
                'label' => 'form.profile.engineer.company.name.label',
                'query_builder' => function(CompanyRepository $er) {
                    return $er->findForUsers(true, true);
                },
                'required' => false,
                'attr' => array(
                    'class' => 'relationship-with-other-field display-other-field-if-no-value'
                ),
            ])
            ->add('establishmentNameOther', TextType::class, [
                'label' => 'form.profile.engineer.company.othername.label',
                'required' => false,
            ])
            ->add('establishmentAddress', TextType::class, array(
                'label' => 'form.profile.engineer.company.address.address.label',
                'required' => false,
            ))
            ->add('establishmentZipcode', TextType::class, array(
                'label' => 'form.profile.engineer.company.address.zipcode.label',
                'required' => false,
            ))
            ->add('establishmentCity', TextType::class, array(
                'label' => 'form.profile.engineer.company.address.city.label', 
                'required' => false,
            ))
            ->add('latitude', TextType::class, array(
                'label' => 'form.profile.engineer.company.address.latitude.label',
                'required' => false
            ))
            ->add('longitude', TextType::class, array(
                'label' => 'form.profile.engineer.company.address.latitude.label',
                'required' => false
            ))
            ->add('establishmentSector', EntityType::class, [
                'class' => OperationPEECategory::class,
                'label' => 'form.profile.engineer.company.sector.label', 
                'query_builder' => function(EntityRepository $er) {
                    return $er
                        ->createQueryBuilder('c')
                        ->where('c.isActive = :is_active')
                        ->setParameter('is_active', true)
                        ->orderBy('c.name')
                    ;
                },
                'required' => false,
                'attr' => array(
                    'class' => 'relationship-with-other-field display-other-field-if-no-value'
                ),
            ])
            ->add('establishmentSectorOther', TextType::class, [
                'label' => 'form.profile.engineer.company.sectorOther.label',
                'required' => false,
            ])
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'translation_domain' => 'form',
            'validation_groups' => function (FormInterface $form) {
                $user = $form->getData();

                return ['admin_profile_' . (UserType::TEACHER === $user->getType() ? 'teacher' : 'engineer')];
            },
        ]);
    }

    /**
     * @return null|string
     */
    public function getParent()
    {
        return ProfileFormType::class;
    }
}
