<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\DemandePEE;
use AppBundle\Entity\SMSModel;
use AppBundle\Entity\User;
use AppBundle\Enum\DemandePEEState;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SMSCampaignPEEType extends AbstractType
{
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $this->operationPeeId = $builder->getData()['ope']->getId();
        //$this->allowedStates = DemandePEEState::getConstants();
        $this->allowedStates = array(DemandePEEState::REGISTERED);
        
        $builder
            ->add('recipients', EntityType::class, array(
                'label' => 'form.sms.campaign.recipients.label',
                'class' => DemandePEE::class,
                'expanded'  => true,
                'multiple'  => true,
                'choice_label'  => function ($demandepee) {
                    $user = $demandepee->getCuser();

                    return '<strong>' . $user->getFirstname() . ' ' . $user->getLastname() . '</strong>&nbsp;&nbsp;<em>' . $demandepee->getState() . '</em>';
                },
                'query_builder' => function(EntityRepository $er) {
                    $qb = $er->createQueryBuilder('d');

                    $qb->where('d.operationpee = :d_operationpee')
                        ->andWhere($qb->expr()->in('d.state', ':d_state'))
                        ->leftJoin('d.cuser', 'u')
                        ->addSelect('u')
                        ->orderBy('d.state', 'ASC')
                        ->addOrderBy('u.firstname', 'ASC')
                        ->setParameters([
                            'd_operationpee' => $this->operationPeeId,
                            'd_state' => $this->allowedStates,
                        ])
                    ;

                    return $qb;
                },
            ))
            ->add('model', EntityType::class, array(
                'label' => 'form.sms.model.label',
                'class' => SMSModel::class,
                'expanded'  => false,
                'multiple'  => false,
                'choice_label'  => function ($model) {
                    return $model->getTitle() . ' - ' . $model->getDescription();
                },
                'query_builder' => function(EntityRepository $er) {
                    return $er->createQueryBuilder('m')
                        ->orderBy('m.title', 'ASC');
                },
                'attr' => array (
                    'data-target' => "#sms_campaign_pee_content",
                    'class' => "load-model"
                )
            ))
            ->add('content', TextareaType::class, array(
                'label' => 'form.sms.campaign.content.label',
                'help' => 'form.sms.campaign.content.help',
                'attr' => array (
                    'id' => "sms_campaign_pee_content",
                    'cols' => "65",
                    'rows' => "8",
                    'class' => "countable",
                    "data-limit" => "160",
                    "data-text-valid" => "%remaining% caractères restants.",
                    "data-text-not-valid" => "%excess% caractères en trop. %modulo% SMS seront envoyés par destinataire.",
                )
            ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'translation_domain' => 'form',
        ));
    }
}
