<?php

namespace AppBundle\Form\Type\Module;

use AppBundle\Entity\Module;
use AppBundle\Enum\MenuClass;
use AppBundle\Enum\ModuleType;
use AppBundle\Helper\ModuleHelper;
use AppBundle\Translation\ConstTranslator;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SliderType extends AbstractType
{
    private $utils;

    /**
     * Constructor
     * 
     * @param ConstTranslator $utils 
     */
    public function __construct(ConstTranslator $utils)
    {
        $this->utils = $utils;
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nb_items', NumberType::class, array(
                'label' => 'form.module.slider.nb_items.label',
                'required' => true,
            ))
        ;    
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'translation_domain' => 'form',
        ));
    }
}
