<?php

namespace AppBundle\Form\Type\Front\User;

use AppBundle\Enum\UserHonorific;
use AppBundle\Helper\UserHelper;
use AppBundle\Repository\UserRepository;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\Query;
use FOS\UserBundle\Form\Type\ProfileFormType as BaseProfileFormType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\BirthdayType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Validator\Constraints\UserPassword;
use Symfony\Component\Validator\Constraints\NotBlank;

class ProfileFormType extends AbstractType
{
    protected $userHonorifics;

    /**
     * Constructor
     * 
     * @param UserRepository $ur
     * @param ConstTranslator $utils
     */
    public function __construct(UserRepository $ur, ConstTranslator $utils)
    {
        $this->userHonorifics = $utils->trans(UserHonorific::class);
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $this->buildUserForm($builder, $options);
        $this->buildPasswordForm($builder, $options);
        
        $builder 
            ->add('submit', SubmitType::class, array(
                'label' => 'form.profile.submit',
                'attr' => array(
                    'class' => 'btn btn-block btn-md btn-theme'
                ),
            ))
        ;
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildUserForm(FormBuilderInterface $builder, array $options)
    {        
        $builder
            ->add('username', HiddenType::class, array(
                //'required' => false
            ))
            ->add('honorific', ChoiceType::class, array(
                'choices' => array_flip($this->userHonorifics),
                //'expanded' => true,
                'label' => 'form.profile.honorific.label',
            ))
            ->add('firstname', TextType::class, array(
                'label' => 'form.profile.firstname.label',
            ))
            ->add('lastname', TextType::class, array(
                'label' => 'form.profile.lastname.label',
            ))
            // ->add('birthday', BirthdayType::class, array(
            //     'format' => 'ddMMMMyyyy',
            //     'label' => 'form.profile.birthday.label',
            //     'required' => false,
            // ))
            ->add('phone', TextType::class, array(
                'label' => 'form.profile.phone.label',
                'required' => false,
            ))
            ->add('mobile', TextType::class, array(
                'help' => 'form.profile.mobile.help', 
                'label' => 'form.profile.mobile.label',
                //'required' => false,
            ))
            ->add('photoFile', FileType::class, array(
                'attr' => array('class' => 'image_input'),
                'help' => 'form.profile.photo.help',
                'image_path' => 'webPhoto',
                'image_filter' => '48Lx48H',
                'label' => 'form.profile.photo.label',
                'required' => false,
            ))
            // @NOTE : Demande Client : Suppression Adresse personnelle - Ingenieur : Garder Code Postal et Ville pour Geolocalisation
            // ->add('personalAddress', TextType::class, array(
            //     'label' => 'form.profile.personaladdress.address.label',
            //     // 'required' => false,
            // ))
            ->add('personalZipcode', TextType::class, array(
                'label' => 'form.profile.personaladdress.zipcode.label',
                // 'required' => false,
            ))
            ->add('personalCity', TextType::class, array(
                'label' => 'form.profile.personaladdress.city.label',
                // 'required' => false,
            ))
            ->add('personalLatitude', HiddenType::class, array(
                'required' => false
            ))
            ->add('personalLongitude', HiddenType::class, array(
                'required' => false
            ))
        ;
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildPasswordForm(FormBuilderInterface $builder, array $options)
    {               
        $builder
            ->remove('current_password')
            ->add('current_password', PasswordType::class, array(
                'label' => 'form.profile.password.current_password.label',
                'mapped' => false,
                // 'constraints' => array(
                //     new NotBlank(),
                //     new UserPassword($constraintsOptions),
                // ),
                'required' => false,
            )) 
            ->add('plainPassword', RepeatedType::class, array(
                'type' => PasswordType::class,
                'options' => array('translation_domain' => 'form'),
                'first_options' => array('label' => 'form.profile.password.new_password.label', 'help' => 'form.profile.password.new_password.help', 'required' => false,),
                'second_options' => array('label' => 'form.profile.password.new_password_confirmation.label', 'required' => false,),
                'invalid_message' => 'form.profile.password.new_password_confirmation.mismatch',
                'required' => false,
            ))
        ;
    }

     /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildCommunicationForm(FormBuilderInterface $builder, array $options)
    {               
        $builder
            ->add('newsletter', CheckboxType::class, array(
                'label' => 'form.profile.newsletter.label',
                'required' => false,
            ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'translation_domain' => 'form',
            'validation_groups' => array(
                'profile'
            ),
        ));
    }

    public function getParent()
    {
        return BaseProfileFormType::class;
    }
}
