<?php

namespace AppBundle\Form\Type\Front\ITDLC;

use AppBundle\Entity\User;
use AppBundle\Enum\EstablishmentType;
use AppBundle\Enum\EstablishmentEducation;
use AppBundle\Enum\UserRep;
use AppBundle\Helper\UserHelper;
use AppBundle\Repository\UserRepository;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\Query;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

class ProfDemandeITDLCStep2Type extends AbstractType
{
    protected $academies;
    protected $repLevels;
    protected $establishmentType;
    protected $establishmentEducation;

    /**
     * Constructor
     * 
     * @param UserRepository $ur
     * @param ConstTranslator $utils
     */
    public function __construct(UserRepository $ur, ConstTranslator $utils)
    {
        $this->establishmentType = $utils->trans(EstablishmentType::class, null, null, null, true);
        $this->establishmentEducation = $utils->trans(EstablishmentEducation::class, null, null, null, true);
        // $this->academies = UserHelper::getAcademyList();
        $this->repLevels = $utils->trans(UserRep::class);
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {        
        $builder 
            ->add('establishmentType', ChoiceType::class, array(
                'choices' => array_flip($this->establishmentType),
                'label' => 'form.profile.teacher.establishment.type.label',
                // 'required' => false,
            ))
            ->add('establishmentEducation', ChoiceType::class, array(
                'choices' => array_flip($this->establishmentEducation),
                'label' => 'form.profile.teacher.establishment.education.label',
                // 'required' => false,
            ))
            ->add('establishmentName', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.name.label',
                // 'required' => false,
            ))
            ->add('establishmentAddress', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.address.address.label',
                // 'required' => false,
            ))
            ->add('establishmentZipcode', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.address.zipcode.label',
                // 'required' => false,
            ))
            ->add('establishmentCity', TextType::class, array(
                'label' => 'form.profile.teacher.establishment.address.city.label', 
                // 'required' => false,
            ))
            // ->add('academy', ChoiceType::class, array(
            //     'choices' => $this->academies,
            //     'label' => 'form.profile.teacher.establishment.academy.label',
            //     'placeholder' => 'form.profile.teacher.establishment.academy.placeholder',
            //     // 'required' => false,
            // ))
            ->add('rep', ChoiceType::class, array(
                'choices' => array_flip($this->repLevels),
                'expanded' => true,
                'label' => 'form.profile.teacher.establishment.rep.label',
                // 'required' => false,
            ))
            // ->add('establishmentEmail', EmailType::class, array(
            //     'label' => 'form.profile.teacher.establishment.email.label',
            //     'required' => false,
            // ))
            ->add('bossEmail', EmailType::class, array(
                'label' => 'form.profile.teacher.establishment.bossEmail.label',
                'help' => 'form.profile.teacher.establishment.bossEmail.help',
                'required' => false,
            ))
            ->add('latitude', HiddenType::class, array(
                'required' => false
            ))
            ->add('longitude', HiddenType::class, array(
                'required' => false
            ))
            // ->add('submit', SubmitType::class, array(
            //     'label' => 'form.itdlc.next',
            //     'attr' => array(
            //         'class' => 'btn btn-sm btn-theme'
            //     ),
            // ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => User::class,
            'translation_domain' => 'form',
            'choice_translation_domain' => 'form',
            'validation_groups' => array(
                'add_itdlc_step2',
                'add_itdlc_teacher_step2',
            ),
        ));
    }
}
