<?php

namespace AppBundle\Form\Type\Front\ITDLC;

use AppBundle\Entity\Company;
use AppBundle\Entity\User;
use AppBundle\Enum\ClassroomLevel;
use AppBundle\Enum\UserHonorific;
use AppBundle\Enum\UserJobEngineer;
use AppBundle\Enum\UserJobEngineerCategory;
use AppBundle\Enum\UserSchoolGrade;
use AppBundle\Helper\UserHelper;
use AppBundle\Repository\CompanyRepository;
use AppBundle\Repository\UserRepository;
use AppBundle\Translation\ConstTranslator;
use FOS\UserBundle\Form\Type\ProfileFormType as BaseProfileFormType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

/**
 *
 */
class IngeDemandeITDLCStep2Type extends AbstractType
{    
    /**
     * Constructor
     * 
     * @param UserRepository $ur
     * @param ConstTranslator $utils
     */
    public function __construct(UserRepository $ur, ConstTranslator $utils)
    {
        $this->jobsCategories = $utils->trans(UserJobEngineerCategory::class);
        $this->jobs = $utils->trans(UserJobEngineer::class);
        $this->formations = $utils->trans(UserSchoolGrade::class);
    }

    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder 
            // ->add('categoryJob', ChoiceType::class, [
            //     'choices' => array_flip($this->jobsCategories),
            //     'label' => 'form.profile.engineer.jobcategory.label',
            //     // 'required' => false,
            // ])
            ->add('job', ChoiceType::class, array(
                'choices' => array_flip($this->jobs),
                'label' => 'form.profile.engineer.job.label',
                // 'required' => false,
                // 'attr' => array(
                //     'class' => 'relationship-with-other-field display-other-field-if-no-value'
                // ),
            ))
            ->add('jobOther', TextType::class, [
                'label' => 'form.profile.engineer.jobother.label',
                // 'required' => false,
            ])
            ->add('formation', ChoiceType::class, [
                'choices' => array_flip($this->formations),
                'label' => 'form.profile.engineer.formation.label',
                // 'required' => false,
            ])
            ->add('formationType', TextType::class, [
                'label' => 'form.profile.engineer.formationType.label',
                // 'required' => false,
            ])
            ->add('aboutMe', TextareaType::class, [
                'label' => 'form.profile.engineer.aboutme.label',
                // 'required' => false,
            ])
            ->add('mobile', TextType::class, array(
                'help' => 'form.profile.mobile.help_it_itldc', 
                'label' => 'form.profile.mobile.label',
                //'required' => false,
            ))
            // @NOTE : Demande Client : Suppression Adresse personnelle - Ingenieur : Garder Code Postal et Ville pour Geolocalisation
            // ->add('personalAddress', TextType::class, array(
            //     'label' => 'form.profile.personaladdress.address.label',
            //     // 'required' => false,
            // ))
            ->add('personalZipcode', TextType::class, array(
                'label' => 'form.profile.personaladdress.zipcode.label',
                // 'required' => false,
            ))
            ->add('personalCity', TextType::class, array(
                'label' => 'form.profile.personaladdress.city.label',
                // 'required' => false,
            ))
            ->add('personalLatitude', HiddenType::class, array(
                'required' => false
            ))
            ->add('personalLongitude', HiddenType::class, array(
                'required' => false
            ))    
            // ->add('submit', SubmitType::class, array(
            //     'label' => 'form.itdlc.next',
            //     'attr' => array(
            //         'class' => 'btn btn-sm btn-theme'
            //     ),
            // ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => User::class,
            'translation_domain' => 'form',
            'validation_groups' => [
                'add_itdlc_step2',
                'add_itdlc_engineer_step2'
            ]
        ]);
    }
}
