<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\Establishment;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatorInterface;
use Vich\UploaderBundle\Form\Type\VichImageType;

/**
 * @author Bastien Gatellier <contact@bgatellier.fr>
 */
class EstablishmentType extends AbstractType
{
    protected $translator;

    /**
     * Constructor
     *
     * @param TranslatorInterface $translator
     */
    public function __construct(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'label' => 'form.name.label',
            ])
            ->add('description', TextareaType::class, [
                'attr' => [
                    'rows' => 15,
                    'class' => 'tinymce'
                ],
                'label' => 'form.description.label',
                'required' => false,
            ])
            ->add('website', UrlType::class, [
                'label' => 'form.website.label',
                'required' => false,
            ])
            ->add('logoFile', VichImageType::class, [
                'download_uri' => false,
                'imagine_pattern' => '30H',
                // translation domain is set to use the VichUploaderBundle domain (default setting).
                // So we have to set the label manually for this field,
                // otherwise we will have to add all the translations related to this field (field label, delete checkbox label)
                // into the 'form' domain.
                'label' => $this->translator->trans('form.logo.label', [], 'form'),
                'required' => false,
            ])
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Establishment::class,
            'translation_domain' => 'form',
        ]);
    }
}
