<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\Document;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Translation\TranslatorInterface;
use Vich\UploaderBundle\Form\Type\VichFileType;

/**
 * @author Bastien Gatellier <contact@bgatellier.fr>
 */
class DocumentType extends AbstractType
{
    protected $translator;

    /**
     * Constructor
     *
     * @param TranslatorInterface $translator
     */
    public function __construct(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('title', TextType::class, [
                'label' => 'form.title.label',
            ])
            ->add('file', VichFileType::class, [
                'allow_delete' => false,
                // translation domain is set to use the VichUploaderBundle domain (default setting).
                // So we have to set the label manually for this field,
                // otherwise we will have to add all the translations related to this field (field label, delete checkbox label)
                // into the 'form' domain.
                'label' => $this->translator->trans('form.document.label', [], 'form'),
            ])
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Document::class,
            'translation_domain' => 'form',
        ]);
    }
}
