<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use AppBundle\Entity\MerITDLC;

/**
 * MerHistory
 *
 * @ORM\Table(name="mer_history_itdlc")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\MerHistoryITDLCRepository")
 * @ORM\HasLifecycleCallbacks
 */
class MerHistoryITDLC
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="infos", type="text")
     */
    private $infos;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="MerITDLC", inversedBy="histories")
     * @ORM\JoinColumn(name="mer_itdlc_id", referencedColumnName="id", nullable=true)
     */
    private $merITDLC;


    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createdAt", type="datetime")
     */
    private $createdAt;


    /**
     * @ORM\PrePersist
     */
    public function setCreatedAtValue()
    {
        $this->createdAt = new \DateTime();
    }


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set infos.
     *
     * @param string $infos
     *
     * @return MerHistory
     */
    public function setInfos($infos)
    {
        $this->infos = $infos;

        return $this;
    }

    /**
     * Get infos.
     *
     * @return string
     */
    public function getInfos()
    {
        return $this->infos;
    }

    /**
     * Set merITDLC.
     *
     * @param MerITDLC $merITDLC
     *
     * @return MerHistory
     */
    public function setMerITDLC(MerITDLC $merITDLC)
    {
        $this->merITDLC = $merITDLC;

        return $this;
    }

    /**
     * Get merITDLC.
     *
     * @return int
     */
    public function getMerITDLC()
    {
        return $this->merITDLC;
    }

    /**
     * Set createdAt.
     *
     * @param \DateTime $createdAt
     *
     * @return MerHistory
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * Get createdAt.
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }
}
