<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="Interest")
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks
 */
class Interest
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\User", inversedBy="interest")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=false)
     */
    private $user;

    /**
     * @var OperationITDLC $operationitdlc
     *
     * @ORM\ManyToOne(targetEntity="OperationITDLC", inversedBy="interest")
     * @ORM\JoinColumn(name="operationitdlc_id", referencedColumnName="id", nullable=true)
     */
    private $operationitdlc;

    /**
     * @var OperationPEE $operationpee
     *
     * @ORM\ManyToOne(targetEntity="OperationPEE", inversedBy="interest")
     * @ORM\JoinColumn(name="operationpee_id", referencedColumnName="id", nullable=true)
     */
    private $operationpee;


    /**
    * Get id
    *
    * @return integer
    */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set user
     *
     * @param User $user
     * 
     * @return Interest
     */
    public function setUser(User $user)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set operationitdlc
     *
     * @param OperationITDLC $operationitdlc
     * 
     * @return Interest
     */
    public function setOperationitdlc(OperationITDLC $operationitdlc)
    {
        $this->operationitdlc = $operationitdlc;

        return $this;
    }

    /**
     * Get operationitdlc
     *
     * @return OperationITDLC
     */
    public function getOperationitdlc()
    {
        return $this->operationitdlc;
    }

    /**
     * Set operationpee
     *
     * @param OperationPEE $operationpee
     * 
     * @return Interest
     */
    public function setOperationpee(OperationPEE $operationpee)
    {
        $this->operationpee = $operationpee;

        return $this;
    }

    /**
     * Get operationpee
     *
     * @return OperationPEE
     */
    public function getOperationpee()
    {
        return $this->operationpee;
    }
}
