<?php

namespace AppBundle\Controller;

use AppBundle\Entity\Module;
use AppBundle\Enum\UserType;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\HttpFoundation\Response;

class ModuleController extends Controller
{
    /**
     * @var EntityManagerInterface
     */
    protected $em;

    /**
     * @var SessionInterface
     */
    protected $session;
    
    public function __construct(
        EntityManagerInterface $em,
        SessionInterface $session
    )
    {
        $this->em = $em;
        $this->session = $session;
    }

    /**
     * @param Int $moduleId Défini le module à afficher
     * @param string $force_layout Définit le type de rendu Twig souhaité
     * @param Int $menuId Défini le menu associé, la page actuelle qui demande l'affichage
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function renderModule(Int $moduleId, string $force_layout = null, Int $menuId = null)
    {
        $module = $this->em->getRepository(Module::class)->findOneBy([
            'isActive' => true, 
            'id' => $moduleId
        ]);
        
        if (empty($module)) {
            return new Response('');
        }

        //Force layout
        if (!empty($force_layout)) {
            $module->setLayout($force_layout);
        }
        
        $module->setFormClass($module->getType());
        $layout = $module->getLayoutPath();

        //Check if layout is correct
        if (!empty($force_layout) && strpos($layout, $force_layout) === false) {
            return new Response('');
        }

        return $this->render($layout , array(
            'module' => $module, 
        ));
    }
}
