<?php

namespace AppBundle\Controller\Module;

use AppBundle\Controller\ModuleController;
use AppBundle\Entity\Menu;
use AppBundle\Entity\Module;
use AppBundle\Enum\UserType;
use Doctrine\ORM\EntityManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;

class NewsListController extends ModuleController
{
    /**
     * @param Int $moduleId Défini le module à afficher
     * @param string $force_layout Définit le type de rendu Twig souhaité
     * @param Int $menuId Défini le menu associé, la page actuelle qui demande l'affichage
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function renderModule(Int $moduleId, string $force_layout = null, Int $menuId = null)
    {
        $module = $this->em->getRepository(Module::class)->findOneBy([
            'isActive' => true, 
            'id' => $moduleId
        ]);
        
        if (empty($module)) {
            return new Response('');
        }

        //Force layout
        if (!empty($force_layout)) {
            $module->setLayout($force_layout);
        }
        
        $module->setFormClass($module->getType());
        $layout = $module->getLayoutPath();

        //Check if layout is correct
        if (!empty($force_layout) && strpos($layout, $force_layout) === false) {
            return new Response('');
        }

        $category = (int) $module->getParams()->category;

        $menu = $this->em->getRepository(Menu::class)->findOneBy(
            ['is_main_actu' => true, 'is_active' => true]
        );

        if ( empty($category) ) {
            // All Categories

            $queryactus = $this->em
                ->createQuery(
                    "SELECT m FROM AppBundle:Content m
                        WHERE m.menu in (SELECT mm.id FROM AppBundle:Menu mm WHERE mm.parent = :menuid)
                            AND m.is_actu = :isactu AND m.is_active=:isactive AND (m.publish < :today OR m.publish IS NULL)
                            AND (m.unpublish > :today OR m.unpublish IS NULL)
                        ORDER BY m.featured DESC, m.publish DESC, m.created DESCS"
                )
                ->setParameters([
                    'menuid' => $menu,
                    'isactu' => 't',
                    'isactive' => 't',
                    'today' => new \DateTime(),
                ])
                ->setMaxResults((int) $module->getParams()->nb_items);
            
        }
        else {
            // Specific category

            $catMenu = $this->em->getRepository(Menu::class)->findOneBy(
                ['id' => $category, 'is_active' => true]
            );

            $queryactus = $this->em
                ->createQuery(
                    "SELECT m FROM AppBundle:Content m
                        WHERE m.menu = :menuid
                            AND m.is_actu = :isactu AND m.is_active=:isactive AND (m.publish < :today OR m.publish IS NULL)
                            AND (m.unpublish > :today OR m.unpublish IS NULL)
                        ORDER BY m.featured DESC, m.publish DESC, m.created DESC"
                )
                ->setParameters([
                    'menuid' => $catMenu,
                    'isactu' => 't',
                    'isactive' => 't',
                    'today' => new \DateTime(),
                ])
                ->setMaxResults((int) $module->getParams()->nb_items);
        }

        $actus = $queryactus->getResult();

        if (empty($actus)) {
            return new Response('');
        }
            
        // Specific to layout cols.html.twig
        switch ( count($actus) ) {
            case 1 :
            case 2 :
            case 3 :
                    $itemClass = "col-lg-6 col-xl-4 add-spacing";
                    break;
            case 4 : 
            default:
                    $itemClass = "col-lg-6 col-xl-3 add-spacing";
                    break;
        }

        return $this->render($layout , array(
            'module' => $module, 
            'actus' => $actus,
            'menu' => $menu,
            'itemcol' => $itemClass,
        ));
    }
}
