<?php

/*******************************************************
 * Only these origins will be allowed to upload images *
 ******************************************************/
$accepted_origins = array("https://sandbox.cgenial.org", "https://preprod.cgenial.org", "https://cgenial.org");

/*********************************************
 * Change this line to set the upload folder *
 *********************************************/
$imageWebFolder = "/uploads/images/";
$imagePathFolder = __DIR__ . "/.." . $imageWebFolder;


reset($_FILES);
$temp = current($_FILES);
if (is_uploaded_file($temp['tmp_name'])) {
  if (isset($_SERVER['HTTP_ORIGIN'])) {
    // same-origin requests won't set an origin. If the origin is set, it must be valid.
    if (in_array($_SERVER['HTTP_ORIGIN'], $accepted_origins)) {
      header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
    } else {
      header("HTTP/1.0 403 Origin Denied");
      return;
    }
  }

  /*
  If your script needs to receive cookies, set images_upload_credentials : true in
  the configuration and enable the following two headers.
   */
  // header('Access-Control-Allow-Credentials: true');
  // header('P3P: CP="There is no P3P policy."');
/*
  // Sanitize input
  if (preg_match("/([^\w\s\d\-_~,;:\[\]\(\).])|([\.]{2,})/", $temp['name'])) {
    header("HTTP/1.0 500 Invalid file name.");
    return;
  }
*/
  // Verify extension
  if (!in_array(strtolower(pathinfo($temp['name'], PATHINFO_EXTENSION)), array("gif", "jpg", "jpeg", "png"))) {
    header("HTTP/1.0 500 Invalid extension.");
    return;
  }

  if (!is_dir($imagePathFolder)) {
    mkdir($imagePathFolder, 0755, true);
  }

  $filename = strtolower( md5(time().$temp['name']) . '-' . $temp['name']);

  // Accept upload if there was no origin, or if it is an accepted origin
  move_uploaded_file($temp['tmp_name'], $imagePathFolder . $filename);

  // Respond to the successful upload with JSON.
  // Use a location key to specify the path to the saved image resource.
  // { location : '/your/uploaded/image/file'}
  echo json_encode(array('location' => $imageWebFolder . $filename));
} else {
  // Notify editor that the upload failed
  header("HTTP/1.0 500 Server Error");
}
