<?php

namespace AppBundle\Validator;

use AppBundle\Entity\Content;
use Symfony\Component\Validator\Context\ExecutionContextInterface;

class ContentValidator
{
    /**
     * @param Content $content
     * @param ExecutionContextInterface $context
     * @param $payload
     */
    public static function validate(Content $content, ExecutionContextInterface $context, $payload): void
    {
        $isActuContent = !$content->getIsModule() && $content->getIsMain() && $content->getIsActu();
        
        if (null === $content->getMenu() && $isActuContent) {
            $context
                ->buildViolation('validators.content.menu.empty')
                ->atPath('menu')
                ->addViolation()
            ;
        }
    }
}
