<?php

namespace AppBundle\Mail;

use AppBundle\Entity\Availability;
use AppBundle\Mail\Model\Mail;
use AppBundle\Enum\ContactCategory;
use AppBundle\Enum\ContactSubject;
use AppBundle\Enum\UserType;
use AppBundle\Entity\User;
use AppBundle\Entity\Contact;


class ContactMailer extends AbstractMailer
{
    /**
     * Notify the user that his application for an operation is confirmed.
     *
     * @param Contact $data
     *
     * @return array Mailer response
     * @throws \Exception
     */
    public function sendContactData(Contact $data, User $user = null): array
    {
        $category = $this->translator->trans('form.contact.category.' . $data->getCategory(), [], 'form');
        $catValue = $data->getCategory();
        $subject = $this->translator->trans('form.contact.subject.' . $data->getSubject(), [], 'form');

        if (is_null($user) === false && is_null($user->getEstablishmentZipcode()) === false) {
            $objet = "[" . substr($user->getEstablishmentZipcode(),0,2) . "] ";
            $objet .= 'Contact : ' . $category . ' - ' . $subject;
        } else {
            $objet = 'Contact : ' . $category . ' - ' . $subject;
        }

        

        $recipients = array();

        if ($catValue == ContactCategory::ITDLC 
            // && ( $subject == ContactSubject::SUBSCRIPTIONS
            //     || $subject == ContactSubject::DISCLAIMER
            //     || $subject == ContactSubject::CANCELLATION
            // )
        ) {
            $recipients = explode(',', $this->getParameter('itdlc_info'));
        // } elseif ($category == ContactCategory::ITDLC && $subject == ContactSubject::INFORMATIONS) {
        //     $mail->addTo($this->getParameter('itdlc_info'), $this->getParameter('label'));
        } elseif ($catValue == ContactCategory::PEE 
            // && ( $subject == ContactSubject::SUBSCRIPTIONS
            //     || $subject == ContactSubject::DISCLAIMER
            //     || $subject == ContactSubject::CANCELLATION
            // )
        ) {
            $recipients = explode(',', $this->getParameter('pee_info'));
        // } elseif ($category == ContactCategory::PEE && $subject == ContactSubject::INFORMATIONS) {
        //     $mail->addTo($this->getParameter('pee_info'), $this->getParameter('label'));
        } elseif ($catValue == ContactCategory::CONTEST) {
            $recipients = explode(',', $this->getParameter('contest'));
        } elseif ($catValue == ContactCategory::YESWECODE) {
            $recipients = explode(',', $this->getParameter('yeswecode'));
        } elseif ($catValue == ContactCategory::PARTNER) {
            $recipients = explode(',', $this->getParameter('partner'));
        } elseif ($catValue == ContactCategory::TAX) {
            $recipients = explode(',', $this->getParameter('tax'));
        } elseif ($catValue == ContactCategory::CONNECT) {
            $recipients = explode(',', $this->getParameter('connect'));
        } elseif ($catValue == ContactCategory::MERCREDIS) {
            $recipients = explode(',', $this->getParameter('mercredis'));
        } elseif ($catValue == ContactCategory::SEMAINE_METIER) {
            $recipients = explode(',', $this->getParameter('semaine_metier'));
        } elseif ($catValue == ContactCategory::RELATION_PRESSE) {
            $recipients = explode(',', $this->getParameter('relation_presse'));
        }  elseif ($catValue == ContactCategory::ATELIER_MIXIT) {
            $recipients = explode(',', $this->getParameter('atelier_mixit'));
        } else {
            $recipients = explode(',', $this->getParameter('contact'));
        }

        foreach ($recipients as $email) {
            $mail = new Mail($objet);
            $mail->addTo(trim($email), $this->getParameter('label'));
            $mail->setFrom($data->getEmail(), $data->getFullname());
            $mail->setHtml(
                $this->renderView('Front/Mail/Contact/contact.html.twig', [
                    'fullname' => $data->getFullname(),
                    'firstname' => $data->getFirstname(),
                    'lastname' => $data->getLastname(),
                    'company' => $data->getCompany(),
                    'email' => $data->getEmail(),
                    'category' => $category,
                    'subject' => $subject,
                    'message' => $data->getMessage(),
                ])
            );

            $responses = $this->send($mail);
        }
        return $responses;
    }
}
