<?php

namespace AppBundle\Helper;

use AppBundle\Entity\Module;
use AppBundle\Enum\ModuleType as ModuleTypeEnum;
use AppBundle\Enum\ModulePosition;

class ModuleHelper
{
    /**
     * Get Type list
     *
     * @return Array
     */
    public static function getTypeList()
    {        
        $consts = ModuleTypeEnum::getConstants();
        
        return array_combine($consts, $consts);
    }

    /**
     * Get Position list
     *
     * @return Array
     */
    public static function getPositionList()
    {        
        $consts = ModulePosition::getConstants();
        
        return array_combine($consts, $consts);
    }

    /**
     * Get Form Class
     *
     * @param Module $module
     * @return FormType
     */
    public static function getModuleFormClass(Module $module)
    {        
        $formClass = $module->getFormClass();
        
        if (!empty($formClass)) {
            $srcDir = __DIR__.'/../../../src/';
            $formPath = $srcDir.'AppBundle/Form/Type/Module/'.$formClass.'Type.php';

            if (file_exists($formPath)) {
                // Auto wiring not working with string... So we changing code with switch
                //return "\\AppBundle\\Form\\Type\\Module\\".$this->formClass."Type";
                
                switch ($formClass) {
                    case "CustomHtml" :
                                        return \AppBundle\Form\Type\Module\CustomHtmlType::class;
                                        break;
                    case "LatestUsers" :
                                        return \AppBundle\Form\Type\Module\LatestUsersType::class;
                                        break; 
                    case "MapPee" :
                                        return \AppBundle\Form\Type\Module\MapPeeType::class;
                                        break;
                    case "MenuChildrenList" :
                                        return \AppBundle\Form\Type\Module\MenuChildrenListType::class;
                                        break;
                    case "NewsList" :
                                        return \AppBundle\Form\Type\Module\NewsListType::class;
                                        break;
                    case "Newsletter" :
                                        return \AppBundle\Form\Type\Module\NewsletterType::class;
                                        break;
                    case "PartnersList" :
                                        return \AppBundle\Form\Type\Module\PartnersListType::class;
                                        break;
                    case "PicturesList" :
                                        return \AppBundle\Form\Type\Module\PicturesListType::class;
                                        break;
                    case "Slider" :
                                        return \AppBundle\Form\Type\Module\SliderType::class;
                                        break;
                    case "SliderVideo" :
                                        return \AppBundle\Form\Type\Module\SliderVideoType::class;
                                        break;
                    case "Social" :
                                        return \AppBundle\Form\Type\Module\SocialType::class;
                                        break;
                    case "TestimonialsList" :
                                        return \AppBundle\Form\Type\Module\TestimonialsListType::class;
                                        break;
                    case "VideosList" :
                                        return \AppBundle\Form\Type\Module\VideosListType::class;
                                        break;
                    default :
                                        break;                
                }
            }
        }

        return null;    
    }

    /**
     * Get Form Class
     *
     * @param Module $module
     * @return Controller
     */
    public static function getModuleControllerClass(Module $module)
    {        
        $formClass = $module->getFormClass();
        
        if (!empty($formClass)) {
            $srcDir = __DIR__.'/../../../src/';
            $formPath = $srcDir.'AppBundle/Controller/Module/'.$formClass.'Controller.php';

            if (file_exists($formPath)) {
                // Auto wiring not working with string... So we changing code with switch
                //return "\\AppBundle\\Form\\Type\\Module\\".$formClass."Type";
                
                switch ($formClass) {
                    case "CustomHtml" :
                                        return \AppBundle\Controller\Module\CustomHtmlController::class;
                                        break;
                    case "LatestUsers" :
                                        return \AppBundle\Controller\Module\LatestUsersController::class;
                                        break;
                    case "MapPee" :
                                        return \AppBundle\Controller\Module\MapPeeController::class;
                                        break;
                    case "MenuChildrenList" :
                                        return \AppBundle\Controller\Module\MenuChildrenListController::class;
                                        break;
                    case "NewsList" :
                                        return \AppBundle\Controller\Module\NewsListController::class;
                                        break;
                    case "Newsletter" :
                                        return \AppBundle\Controller\Module\NewsletterController::class;
                                        break;
                    case "PartnersList" :
                                        return \AppBundle\Controller\Module\PartnersListController::class;
                                        break;
                    case "PicturesList" :
                                        return \AppBundle\Controller\Module\PicturesListController::class;
                                        break;
                    case "Slider" :
                                        return \AppBundle\Controller\Module\SliderController::class;
                                        break;
                    case "SliderVideo" :
                                        return \AppBundle\Controller\Module\SliderVideoController::class;
                                        break;
                    case "Social" :
                                        return \AppBundle\Controller\Module\SocialController::class;
                                        break;
                    case "TestimonialsList" :
                                        return \AppBundle\Controller\Module\TestimonialsListController::class;
                                        break;
                    case "VideosList" :
                                        return \AppBundle\Controller\Module\VideosListController::class;
                                        break;
                    default :
                                        return \AppBundle\Controller\ModuleController::class;
                                        break;                
                }
            }
        }

        return \AppBundle\Controller\ModuleController::class;   
    }
}
