<?php

namespace AppBundle\Form\Type;

use AppBundle\Entity\SMSModel;
use AppBundle\Translation\ConstTranslator;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SMSModelType extends AbstractType
{
    /**
     * 
     * @param FormBuilderInterface $builder 
     * @param array $options 
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('title', TextType::class, array(
                'label' => 'form.sms.model.title.label',
            ))
            ->add('description', TextType::class, array(
                'label' => 'form.sms.model.description.label',
                'required' => false,
            ))
            ->add('content', TextareaType::class, array(
                'label' => 'form.sms.model.content.label',
                'help' => 'form.sms.model.content.help',
                'attr' => array (
                    'class' => "countable",
                    'cols' => "65",
                    'rows' => "8",                   
                    "data-limit" => "160",
                    "data-text-valid" => "%remaining% caractères restants.",
                    "data-text-not-valid" => "%excess% caractères en trop. %modulo% SMS seront envoyés par destinataire.",
                )
            ))
            ->add('isActive', CheckboxType::class, array(
                'label' => 'form.sms.model.is_active.label',
                'required' => false,
            ))
        ;
    }

    /**
     * 
     * @param OptionsResolver $resolver 
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => SMSModel::class,
            'translation_domain' => 'form',
        ));
    }
}
